/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.internal;

import java.net.URI;
import java.time.Clock;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;

@SdkInternalApi
public abstract class RdsPresignInterceptor<T extends DocDbRequest>
implements ExecutionInterceptor {
    private static final URI CUSTOM_ENDPOINT_LOCALHOST = URI.create("http://localhost");
    protected static final AwsQueryProtocolFactory PROTOCOL_FACTORY = AwsQueryProtocolFactory.builder().clientConfiguration(SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.ENDPOINT, (Object)CUSTOM_ENDPOINT_LOCALHOST).build()).build();
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Clock signingOverrideClock;

    protected RdsPresignInterceptor(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    protected RdsPresignInterceptor(Class<T> requestClassToPreSign, Clock signingOverrideClock) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingOverrideClock = signingOverrideClock;
    }

    public final SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (!this.requestClassToPreSign.isInstance(originalRequest)) {
            return request;
        }
        if (request.rawQueryParameters().containsKey(PARAM_PRESIGNED_URL)) {
            return request;
        }
        PresignableRequest presignableRequest = this.adaptRequest((DocDbRequest)((Object)this.requestClassToPreSign.cast(originalRequest)));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return request;
        }
        String destinationRegion = ((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION)).id();
        URI endpoint = this.createEndpoint(sourceRegion, SERVICE_NAME);
        SdkHttpFullRequest.Builder marshalledRequest = presignableRequest.marshall().toBuilder().uri(endpoint);
        SdkHttpFullRequest requestToPresign = marshalledRequest.method(SdkHttpMethod.GET).putRawQueryParameter(PARAM_DESTINATION_REGION, destinationRegion).removeQueryParameter(PARAM_SOURCE_REGION).build();
        requestToPresign = this.presignRequest(requestToPresign, executionAttributes, sourceRegion);
        String presignedUrl = requestToPresign.getUri().toString();
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter(PARAM_PRESIGNED_URL, presignedUrl).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private SdkHttpFullRequest presignRequest(SdkHttpFullRequest request, ExecutionAttributes attributes, String signingRegion) {
        Aws4Signer signer = Aws4Signer.create();
        Aws4PresignerParams presignerParams = ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingRegion(Region.of((String)signingRegion))).signingName(SERVICE_NAME)).signingClockOverride(this.signingOverrideClock)).awsCredentials((AwsCredentials)attributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS))).build();
        return signer.presign(request, presignerParams);
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw SdkClientException.builder().message("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.").build();
        }
        return new DefaultServiceEndpointBuilder(SERVICE_NAME, Protocol.HTTPS.toString()).withRegion(region).getServiceEndpoint();
    }

    public static interface PresignableRequest {
        public String getSourceRegion();

        public SdkHttpFullRequest marshall();
    }
}

