/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.Filter;
import software.amazon.awssdk.services.docdb.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbEngineVersionsRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, DescribeDbEngineVersionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::engine)).setter(DescribeDbEngineVersionsRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::engineVersion)).setter(DescribeDbEngineVersionsRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::dbParameterGroupFamily)).setter(DescribeDbEngineVersionsRequest.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::filters)).setter(DescribeDbEngineVersionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::maxRecords)).setter(DescribeDbEngineVersionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::marker)).setter(DescribeDbEngineVersionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::defaultOnly)).setter(DescribeDbEngineVersionsRequest.setter(Builder::defaultOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOnly").build()}).build();
    private static final SdkField<Boolean> LIST_SUPPORTED_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::listSupportedCharacterSets)).setter(DescribeDbEngineVersionsRequest.setter(Builder::listSupportedCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListSupportedCharacterSets").build()}).build();
    private static final SdkField<Boolean> LIST_SUPPORTED_TIMEZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeDbEngineVersionsRequest.getter(DescribeDbEngineVersionsRequest::listSupportedTimezones)).setter(DescribeDbEngineVersionsRequest.setter(Builder::listSupportedTimezones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListSupportedTimezones").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, DEFAULT_ONLY_FIELD, LIST_SUPPORTED_CHARACTER_SETS_FIELD, LIST_SUPPORTED_TIMEZONES_FIELD));
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean defaultOnly;
    private final Boolean listSupportedCharacterSets;
    private final Boolean listSupportedTimezones;

    private DescribeDbEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
        this.listSupportedCharacterSets = builder.listSupportedCharacterSets;
        this.listSupportedTimezones = builder.listSupportedTimezones;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean defaultOnly() {
        return this.defaultOnly;
    }

    public Boolean listSupportedCharacterSets() {
        return this.listSupportedCharacterSets;
    }

    public Boolean listSupportedTimezones() {
        return this.listSupportedTimezones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.listSupportedCharacterSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.listSupportedTimezones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbEngineVersionsRequest)) {
            return false;
        }
        DescribeDbEngineVersionsRequest other = (DescribeDbEngineVersionsRequest)((Object)obj);
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.defaultOnly(), other.defaultOnly()) && Objects.equals(this.listSupportedCharacterSets(), other.listSupportedCharacterSets()) && Objects.equals(this.listSupportedTimezones(), other.listSupportedTimezones());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbEngineVersionsRequest").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("DefaultOnly", (Object)this.defaultOnly()).add("ListSupportedCharacterSets", (Object)this.listSupportedCharacterSets()).add("ListSupportedTimezones", (Object)this.listSupportedTimezones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DefaultOnly": {
                return Optional.ofNullable(clazz.cast(this.defaultOnly()));
            }
            case "ListSupportedCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.listSupportedCharacterSets()));
            }
            case "ListSupportedTimezones": {
                return Optional.ofNullable(clazz.cast(this.listSupportedTimezones()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbEngineVersionsRequest, T> g) {
        return obj -> g.apply((DescribeDbEngineVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;
        private Boolean defaultOnly;
        private Boolean listSupportedCharacterSets;
        private Boolean listSupportedTimezones;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbEngineVersionsRequest model) {
            super(model);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.defaultOnly(model.defaultOnly);
            this.listSupportedCharacterSets(model.listSupportedCharacterSets);
            this.listSupportedTimezones(model.listSupportedTimezones);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        public final Boolean getListSupportedCharacterSets() {
            return this.listSupportedCharacterSets;
        }

        @Override
        public final Builder listSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
            return this;
        }

        public final void setListSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
        }

        public final Boolean getListSupportedTimezones() {
            return this.listSupportedTimezones;
        }

        @Override
        public final Builder listSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
            return this;
        }

        public final void setListSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbEngineVersionsRequest build() {
            return new DescribeDbEngineVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbEngineVersionsRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder listSupportedCharacterSets(Boolean var1);

        public Builder listSupportedTimezones(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

