/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicySummary> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::policyId)).setter(LifecyclePolicySummary.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::description)).setter(LifecyclePolicySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::stateAsString)).setter(LifecyclePolicySummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, DESCRIPTION_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String description;
    private final String state;

    private LifecyclePolicySummary(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
    }

    public String policyId() {
        return this.policyId;
    }

    public String description() {
        return this.description;
    }

    public GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicySummary)) {
            return false;
        }
        LifecyclePolicySummary other = (LifecyclePolicySummary)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"LifecyclePolicySummary").add("PolicyId", (Object)this.policyId()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicySummary, T> g) {
        return obj -> g.apply((LifecyclePolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String description;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicySummary model) {
            this.policyId(model.policyId);
            this.description(model.description);
            this.state(model.state);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public LifecyclePolicySummary build() {
            return new LifecyclePolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicySummary> {
        public Builder policyId(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(GettablePolicyStateValues var1);
    }
}

