/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.directory.DefaultDirectoryAsyncClient;
import software.amazon.awssdk.services.directory.DefaultDirectoryBaseClientBuilder;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.DirectoryAsyncClientBuilder;
import software.amazon.awssdk.services.directory.DirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.directory.endpoints.DirectoryEndpointProvider;

@SdkInternalApi
final class DefaultDirectoryAsyncClientBuilder
extends DefaultDirectoryBaseClientBuilder<DirectoryAsyncClientBuilder, DirectoryAsyncClient>
implements DirectoryAsyncClientBuilder {
    DefaultDirectoryAsyncClientBuilder() {
    }

    @Override
    public DefaultDirectoryAsyncClientBuilder endpointProvider(DirectoryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DirectoryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDirectoryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DirectoryServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDirectoryAsyncClient client = new DefaultDirectoryAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DirectoryServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DirectoryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

