/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AssociatedGateway;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAssociationProposal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGatewayAssociationProposal> {
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::proposalId)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::proposalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::directConnectGatewayId)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::directConnectGatewayOwnerAccount)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::directConnectGatewayOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayOwnerAccount").build()}).build();
    private static final SdkField<String> PROPOSAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::proposalStateAsString)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::proposalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalState").build()}).build();
    private static final SdkField<AssociatedGateway> ASSOCIATED_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::associatedGateway)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::associatedGateway)).constructor(AssociatedGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGateway").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> EXISTING_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::existingAllowedPrefixesToDirectConnectGateway)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::existingAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> REQUESTED_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DirectConnectGatewayAssociationProposal.getter(DirectConnectGatewayAssociationProposal::requestedAllowedPrefixesToDirectConnectGateway)).setter(DirectConnectGatewayAssociationProposal.setter(Builder::requestedAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_ID_FIELD, DIRECT_CONNECT_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD, PROPOSAL_STATE_FIELD, ASSOCIATED_GATEWAY_FIELD, EXISTING_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, REQUESTED_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String proposalId;
    private final String directConnectGatewayId;
    private final String directConnectGatewayOwnerAccount;
    private final String proposalState;
    private final AssociatedGateway associatedGateway;
    private final List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway;
    private final List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway;

    private DirectConnectGatewayAssociationProposal(BuilderImpl builder) {
        this.proposalId = builder.proposalId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayOwnerAccount = builder.directConnectGatewayOwnerAccount;
        this.proposalState = builder.proposalState;
        this.associatedGateway = builder.associatedGateway;
        this.existingAllowedPrefixesToDirectConnectGateway = builder.existingAllowedPrefixesToDirectConnectGateway;
        this.requestedAllowedPrefixesToDirectConnectGateway = builder.requestedAllowedPrefixesToDirectConnectGateway;
    }

    public String proposalId() {
        return this.proposalId;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String directConnectGatewayOwnerAccount() {
        return this.directConnectGatewayOwnerAccount;
    }

    public DirectConnectGatewayAssociationProposalState proposalState() {
        return DirectConnectGatewayAssociationProposalState.fromValue(this.proposalState);
    }

    public String proposalStateAsString() {
        return this.proposalState;
    }

    public AssociatedGateway associatedGateway() {
        return this.associatedGateway;
    }

    public List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway() {
        return this.existingAllowedPrefixesToDirectConnectGateway;
    }

    public List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway() {
        return this.requestedAllowedPrefixesToDirectConnectGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingAllowedPrefixesToDirectConnectGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedAllowedPrefixesToDirectConnectGateway());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociationProposal)) {
            return false;
        }
        DirectConnectGatewayAssociationProposal other = (DirectConnectGatewayAssociationProposal)obj;
        return Objects.equals(this.proposalId(), other.proposalId()) && Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.directConnectGatewayOwnerAccount(), other.directConnectGatewayOwnerAccount()) && Objects.equals(this.proposalStateAsString(), other.proposalStateAsString()) && Objects.equals(this.associatedGateway(), other.associatedGateway()) && Objects.equals(this.existingAllowedPrefixesToDirectConnectGateway(), other.existingAllowedPrefixesToDirectConnectGateway()) && Objects.equals(this.requestedAllowedPrefixesToDirectConnectGateway(), other.requestedAllowedPrefixesToDirectConnectGateway());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGatewayAssociationProposal").add("ProposalId", (Object)this.proposalId()).add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("DirectConnectGatewayOwnerAccount", (Object)this.directConnectGatewayOwnerAccount()).add("ProposalState", (Object)this.proposalStateAsString()).add("AssociatedGateway", (Object)this.associatedGateway()).add("ExistingAllowedPrefixesToDirectConnectGateway", this.existingAllowedPrefixesToDirectConnectGateway()).add("RequestedAllowedPrefixesToDirectConnectGateway", this.requestedAllowedPrefixesToDirectConnectGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "proposalId": {
                return Optional.ofNullable(clazz.cast(this.proposalId()));
            }
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "directConnectGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayOwnerAccount()));
            }
            case "proposalState": {
                return Optional.ofNullable(clazz.cast(this.proposalStateAsString()));
            }
            case "associatedGateway": {
                return Optional.ofNullable(clazz.cast(this.associatedGateway()));
            }
            case "existingAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.existingAllowedPrefixesToDirectConnectGateway()));
            }
            case "requestedAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.requestedAllowedPrefixesToDirectConnectGateway()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAssociationProposal, T> g) {
        return obj -> g.apply((DirectConnectGatewayAssociationProposal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proposalId;
        private String directConnectGatewayId;
        private String directConnectGatewayOwnerAccount;
        private String proposalState;
        private AssociatedGateway associatedGateway;
        private List<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();
        private List<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociationProposal model) {
            this.proposalId(model.proposalId);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.directConnectGatewayOwnerAccount(model.directConnectGatewayOwnerAccount);
            this.proposalState(model.proposalState);
            this.associatedGateway(model.associatedGateway);
            this.existingAllowedPrefixesToDirectConnectGateway(model.existingAllowedPrefixesToDirectConnectGateway);
            this.requestedAllowedPrefixesToDirectConnectGateway(model.requestedAllowedPrefixesToDirectConnectGateway);
        }

        public final String getProposalId() {
            return this.proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayOwnerAccount() {
            return this.directConnectGatewayOwnerAccount;
        }

        @Override
        public final Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
            return this;
        }

        public final void setDirectConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
        }

        public final String getProposalStateAsString() {
            return this.proposalState;
        }

        @Override
        public final Builder proposalState(String proposalState) {
            this.proposalState = proposalState;
            return this;
        }

        @Override
        public final Builder proposalState(DirectConnectGatewayAssociationProposalState proposalState) {
            this.proposalState(proposalState.toString());
            return this;
        }

        public final void setProposalState(String proposalState) {
            this.proposalState = proposalState;
        }

        public final AssociatedGateway.Builder getAssociatedGateway() {
            return this.associatedGateway != null ? this.associatedGateway.toBuilder() : null;
        }

        @Override
        public final Builder associatedGateway(AssociatedGateway associatedGateway) {
            this.associatedGateway = associatedGateway;
            return this;
        }

        public final void setAssociatedGateway(AssociatedGateway.BuilderImpl associatedGateway) {
            this.associatedGateway = associatedGateway != null ? associatedGateway.build() : null;
        }

        public final Collection<RouteFilterPrefix.Builder> getExistingAllowedPrefixesToDirectConnectGateway() {
            return this.existingAllowedPrefixesToDirectConnectGateway != null ? (Collection)this.existingAllowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder existingAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(existingAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway(Arrays.asList(existingAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway(Stream.of(existingAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExistingAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> existingAllowedPrefixesToDirectConnectGateway) {
            this.existingAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(existingAllowedPrefixesToDirectConnectGateway);
        }

        public final Collection<RouteFilterPrefix.Builder> getRequestedAllowedPrefixesToDirectConnectGateway() {
            return this.requestedAllowedPrefixesToDirectConnectGateway != null ? (Collection)this.requestedAllowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(requestedAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway(Arrays.asList(requestedAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway(Stream.of(requestedAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequestedAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> requestedAllowedPrefixesToDirectConnectGateway) {
            this.requestedAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(requestedAllowedPrefixesToDirectConnectGateway);
        }

        public DirectConnectGatewayAssociationProposal build() {
            return new DirectConnectGatewayAssociationProposal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGatewayAssociationProposal> {
        public Builder proposalId(String var1);

        public Builder directConnectGatewayId(String var1);

        public Builder directConnectGatewayOwnerAccount(String var1);

        public Builder proposalState(String var1);

        public Builder proposalState(DirectConnectGatewayAssociationProposalState var1);

        public Builder associatedGateway(AssociatedGateway var1);

        default public Builder associatedGateway(Consumer<AssociatedGateway.Builder> associatedGateway) {
            return this.associatedGateway((AssociatedGateway)((AssociatedGateway.Builder)AssociatedGateway.builder().applyMutation(associatedGateway)).build());
        }

        public Builder existingAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder existingAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder existingAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder requestedAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder requestedAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder requestedAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);
    }
}

