/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InterconnectState {
    REQUESTED("requested"),
    PENDING("pending"),
    AVAILABLE("available"),
    DOWN("down"),
    DELETING("deleting"),
    DELETED("deleted"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InterconnectState> VALUE_MAP;
    private final String value;

    private InterconnectState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InterconnectState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InterconnectState> knownValues() {
        EnumSet<InterconnectState> knownValues = EnumSet.allOf(InterconnectState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InterconnectState.class, InterconnectState::toString);
    }
}

