/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocatePrivateVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocatePrivateVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(AllocatePrivateVirtualInterfaceRequest.getter(AllocatePrivateVirtualInterfaceRequest::connectionId)).setter(AllocatePrivateVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(AllocatePrivateVirtualInterfaceRequest.getter(AllocatePrivateVirtualInterfaceRequest::ownerAccount)).setter(AllocatePrivateVirtualInterfaceRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<NewPrivateVirtualInterfaceAllocation> NEW_PRIVATE_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newPrivateVirtualInterfaceAllocation").getter(AllocatePrivateVirtualInterfaceRequest.getter(AllocatePrivateVirtualInterfaceRequest::newPrivateVirtualInterfaceAllocation)).setter(AllocatePrivateVirtualInterfaceRequest.setter(Builder::newPrivateVirtualInterfaceAllocation)).constructor(NewPrivateVirtualInterfaceAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPrivateVirtualInterfaceAllocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, OWNER_ACCOUNT_FIELD, NEW_PRIVATE_VIRTUAL_INTERFACE_ALLOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllocatePrivateVirtualInterfaceRequest.memberNameToFieldInitializer();
    private final String connectionId;
    private final String ownerAccount;
    private final NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

    private AllocatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPrivateVirtualInterfaceAllocation = builder.newPrivateVirtualInterfaceAllocation;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation() {
        return this.newPrivateVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPrivateVirtualInterfaceAllocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePrivateVirtualInterfaceRequest other = (AllocatePrivateVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.newPrivateVirtualInterfaceAllocation(), other.newPrivateVirtualInterfaceAllocation());
    }

    public final String toString() {
        return ToString.builder((String)"AllocatePrivateVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("NewPrivateVirtualInterfaceAllocation", (Object)this.newPrivateVirtualInterfaceAllocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "newPrivateVirtualInterfaceAllocation": {
                return Optional.ofNullable(clazz.cast(this.newPrivateVirtualInterfaceAllocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("newPrivateVirtualInterfaceAllocation", NEW_PRIVATE_VIRTUAL_INTERFACE_ALLOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocatePrivateVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocatePrivateVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePrivateVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.newPrivateVirtualInterfaceAllocation(model.newPrivateVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final NewPrivateVirtualInterfaceAllocation.Builder getNewPrivateVirtualInterfaceAllocation() {
            return this.newPrivateVirtualInterfaceAllocation != null ? this.newPrivateVirtualInterfaceAllocation.toBuilder() : null;
        }

        public final void setNewPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation.BuilderImpl newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation != null ? newPrivateVirtualInterfaceAllocation.build() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocatePrivateVirtualInterfaceRequest build() {
            return new AllocatePrivateVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocatePrivateVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation var1);

        default public Builder newPrivateVirtualInterfaceAllocation(Consumer<NewPrivateVirtualInterfaceAllocation.Builder> newPrivateVirtualInterfaceAllocation) {
            return this.newPrivateVirtualInterfaceAllocation((NewPrivateVirtualInterfaceAllocation)((NewPrivateVirtualInterfaceAllocation.Builder)NewPrivateVirtualInterfaceAllocation.builder().applyMutation(newPrivateVirtualInterfaceAllocation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

