/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GatewayType {
    VIRTUAL_PRIVATE_GATEWAY("virtualPrivateGateway"),
    TRANSIT_GATEWAY("transitGateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GatewayType> VALUE_MAP;
    private final String value;

    private GatewayType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GatewayType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GatewayType> knownValues() {
        EnumSet<GatewayType> knownValues = EnumSet.allOf(GatewayType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GatewayType.class, GatewayType::toString);
    }
}

