/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightFeedback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightFeedback> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InsightFeedback.getter(InsightFeedback::id)).setter(InsightFeedback.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feedback").getter(InsightFeedback.getter(InsightFeedback::feedbackAsString)).setter(InsightFeedback.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FEEDBACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightFeedback.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String feedback;

    private InsightFeedback(BuilderImpl builder) {
        this.id = builder.id;
        this.feedback = builder.feedback;
    }

    public final String id() {
        return this.id;
    }

    public final InsightFeedbackOption feedback() {
        return InsightFeedbackOption.fromValue(this.feedback);
    }

    public final String feedbackAsString() {
        return this.feedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightFeedback)) {
            return false;
        }
        InsightFeedback other = (InsightFeedback)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.feedbackAsString(), other.feedbackAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InsightFeedback").add("Id", (Object)this.id()).add("Feedback", (Object)this.feedbackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("Feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightFeedback, T> g) {
        return obj -> g.apply((InsightFeedback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightFeedback model) {
            this.id(model.id);
            this.feedback(model.feedback);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(InsightFeedbackOption feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public InsightFeedback build() {
            return new InsightFeedback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightFeedback> {
        public Builder id(String var1);

        public Builder feedback(String var1);

        public Builder feedback(InsightFeedbackOption var1);
    }
}

