/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter;

public class GetResourceCollectionIterable
implements SdkIterable<GetResourceCollectionResponse> {
    private final DevOpsGuruClient client;
    private final GetResourceCollectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceCollectionIterable(DevOpsGuruClient client, GetResourceCollectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetResourceCollectionResponseFetcher();
    }

    public Iterator<GetResourceCollectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> stackNames() {
        Function<GetResourceCollectionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCollection() != null && response.resourceCollection().cloudFormation() != null && response.resourceCollection().cloudFormation().stackNames() != null) {
                return response.resourceCollection().cloudFormation().stackNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<TagCollectionFilter> tags() {
        Function<GetResourceCollectionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCollection() != null && response.resourceCollection().tags() != null) {
                return response.resourceCollection().tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourceCollectionResponseFetcher
    implements SyncPageFetcher<GetResourceCollectionResponse> {
        private GetResourceCollectionResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceCollectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceCollectionResponse nextPage(GetResourceCollectionResponse previousPage) {
            if (previousPage == null) {
                return GetResourceCollectionIterable.this.client.getResourceCollection(GetResourceCollectionIterable.this.firstRequest);
            }
            return GetResourceCollectionIterable.this.client.getResourceCollection((GetResourceCollectionRequest)((Object)GetResourceCollectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

