/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup;
import software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroupsCopier;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomalousLogGroupsResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListAnomalousLogGroupsResponse> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(ListAnomalousLogGroupsResponse.getter(ListAnomalousLogGroupsResponse::insightId)).setter(ListAnomalousLogGroupsResponse.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<List<AnomalousLogGroup>> ANOMALOUS_LOG_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalousLogGroups").getter(ListAnomalousLogGroupsResponse.getter(ListAnomalousLogGroupsResponse::anomalousLogGroups)).setter(ListAnomalousLogGroupsResponse.setter(Builder::anomalousLogGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalousLogGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalousLogGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomalousLogGroupsResponse.getter(ListAnomalousLogGroupsResponse::nextToken)).setter(ListAnomalousLogGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD, ANOMALOUS_LOG_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnomalousLogGroupsResponse.memberNameToFieldInitializer();
    private final String insightId;
    private final List<AnomalousLogGroup> anomalousLogGroups;
    private final String nextToken;

    private ListAnomalousLogGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
        this.anomalousLogGroups = builder.anomalousLogGroups;
        this.nextToken = builder.nextToken;
    }

    public final String insightId() {
        return this.insightId;
    }

    public final boolean hasAnomalousLogGroups() {
        return this.anomalousLogGroups != null && !(this.anomalousLogGroups instanceof SdkAutoConstructList);
    }

    public final List<AnomalousLogGroup> anomalousLogGroups() {
        return this.anomalousLogGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalousLogGroups() ? this.anomalousLogGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalousLogGroupsResponse)) {
            return false;
        }
        ListAnomalousLogGroupsResponse other = (ListAnomalousLogGroupsResponse)((Object)obj);
        return Objects.equals(this.insightId(), other.insightId()) && this.hasAnomalousLogGroups() == other.hasAnomalousLogGroups() && Objects.equals(this.anomalousLogGroups(), other.anomalousLogGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomalousLogGroupsResponse").add("InsightId", (Object)this.insightId()).add("AnomalousLogGroups", this.hasAnomalousLogGroups() ? this.anomalousLogGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "AnomalousLogGroups": {
                return Optional.ofNullable(clazz.cast(this.anomalousLogGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InsightId", INSIGHT_ID_FIELD);
        map.put("AnomalousLogGroups", ANOMALOUS_LOG_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalousLogGroupsResponse, T> g) {
        return obj -> g.apply((ListAnomalousLogGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private String insightId;
        private List<AnomalousLogGroup> anomalousLogGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalousLogGroupsResponse model) {
            super(model);
            this.insightId(model.insightId);
            this.anomalousLogGroups(model.anomalousLogGroups);
            this.nextToken(model.nextToken);
        }

        public final String getInsightId() {
            return this.insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final List<AnomalousLogGroup.Builder> getAnomalousLogGroups() {
            List<AnomalousLogGroup.Builder> result = AnomalousLogGroupsCopier.copyToBuilder(this.anomalousLogGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalousLogGroups(Collection<AnomalousLogGroup.BuilderImpl> anomalousLogGroups) {
            this.anomalousLogGroups = AnomalousLogGroupsCopier.copyFromBuilder(anomalousLogGroups);
        }

        @Override
        public final Builder anomalousLogGroups(Collection<AnomalousLogGroup> anomalousLogGroups) {
            this.anomalousLogGroups = AnomalousLogGroupsCopier.copy(anomalousLogGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalousLogGroups(AnomalousLogGroup ... anomalousLogGroups) {
            this.anomalousLogGroups(Arrays.asList(anomalousLogGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalousLogGroups(Consumer<AnomalousLogGroup.Builder> ... anomalousLogGroups) {
            this.anomalousLogGroups(Stream.of(anomalousLogGroups).map(c -> (AnomalousLogGroup)((AnomalousLogGroup.Builder)AnomalousLogGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalousLogGroupsResponse build() {
            return new ListAnomalousLogGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomalousLogGroupsResponse> {
        public Builder insightId(String var1);

        public Builder anomalousLogGroups(Collection<AnomalousLogGroup> var1);

        public Builder anomalousLogGroups(AnomalousLogGroup ... var1);

        public Builder anomalousLogGroups(Consumer<AnomalousLogGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

