/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountHealth> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountHealth.getter(AccountHealth::accountId)).setter(AccountHealth.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<AccountInsightHealth> INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Insight").getter(AccountHealth.getter(AccountHealth::insight)).setter(AccountHealth.setter(Builder::insight)).constructor(AccountInsightHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, INSIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountHealth.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final AccountInsightHealth insight;

    private AccountHealth(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.insight = builder.insight;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AccountInsightHealth insight() {
        return this.insight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.insight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountHealth)) {
            return false;
        }
        AccountHealth other = (AccountHealth)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.insight(), other.insight());
    }

    public final String toString() {
        return ToString.builder((String)"AccountHealth").add("AccountId", (Object)this.accountId()).add("Insight", (Object)this.insight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Insight": {
                return Optional.ofNullable(clazz.cast(this.insight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountHealth, T> g) {
        return obj -> g.apply((AccountHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private AccountInsightHealth insight;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountHealth model) {
            this.accountId(model.accountId);
            this.insight(model.insight);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final AccountInsightHealth.Builder getInsight() {
            return this.insight != null ? this.insight.toBuilder() : null;
        }

        public final void setInsight(AccountInsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(AccountInsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public AccountHealth build() {
            return new AccountHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountHealth> {
        public Builder accountId(String var1);

        public Builder insight(AccountInsightHealth var1);

        default public Builder insight(Consumer<AccountInsightHealth.Builder> insight) {
            return this.insight((AccountInsightHealth)((AccountInsightHealth.Builder)AccountInsightHealth.builder().applyMutation(insight)).build());
        }
    }
}

