/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationCollection;
import software.amazon.awssdk.services.devopsguru.model.TagCollection;
import software.amazon.awssdk.services.devopsguru.model.TagCollectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceCollection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceCollection> {
    private static final SdkField<CloudFormationCollection> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFormation").getter(ResourceCollection.getter(ResourceCollection::cloudFormation)).setter(ResourceCollection.setter(Builder::cloudFormation)).constructor(CloudFormationCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()}).build();
    private static final SdkField<List<TagCollection>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ResourceCollection.getter(ResourceCollection::tags)).setter(ResourceCollection.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudFormation", CLOUD_FORMATION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CloudFormationCollection cloudFormation;
    private final List<TagCollection> tags;

    private ResourceCollection(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.tags = builder.tags;
    }

    public final CloudFormationCollection cloudFormation() {
        return this.cloudFormation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagCollection> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollection)) {
            return false;
        }
        ResourceCollection other = (ResourceCollection)obj;
        return Objects.equals(this.cloudFormation(), other.cloudFormation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceCollection").add("CloudFormation", (Object)this.cloudFormation()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCollection, T> g) {
        return obj -> g.apply((ResourceCollection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudFormationCollection cloudFormation;
        private List<TagCollection> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCollection model) {
            this.cloudFormation(model.cloudFormation);
            this.tags(model.tags);
        }

        public final CloudFormationCollection.Builder getCloudFormation() {
            return this.cloudFormation != null ? this.cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationCollection.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public final Builder cloudFormation(CloudFormationCollection cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final List<TagCollection.Builder> getTags() {
            List<TagCollection.Builder> result = TagCollectionsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagCollection.BuilderImpl> tags) {
            this.tags = TagCollectionsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagCollection> tags) {
            this.tags = TagCollectionsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagCollection ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagCollection.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagCollection)((TagCollection.Builder)TagCollection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceCollection build() {
            return new ResourceCollection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceCollection> {
        public Builder cloudFormation(CloudFormationCollection var1);

        default public Builder cloudFormation(Consumer<CloudFormationCollection.Builder> cloudFormation) {
            return this.cloudFormation((CloudFormationCollection)((CloudFormationCollection.Builder)CloudFormationCollection.builder().applyMutation(cloudFormation)).build());
        }

        public Builder tags(Collection<TagCollection> var1);

        public Builder tags(TagCollection ... var1);

        public Builder tags(Consumer<TagCollection.Builder> ... var1);
    }
}

