/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.EventClass;
import software.amazon.awssdk.services.devopsguru.model.EventDataSource;
import software.amazon.awssdk.services.devopsguru.model.EventTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListEventsFilters> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(ListEventsFilters.getter(ListEventsFilters::insightId)).setter(ListEventsFilters.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<EventTimeRange> EVENT_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventTimeRange").getter(ListEventsFilters.getter(ListEventsFilters::eventTimeRange)).setter(ListEventsFilters.setter(Builder::eventTimeRange)).constructor(EventTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeRange").build()}).build();
    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventClass").getter(ListEventsFilters.getter(ListEventsFilters::eventClassAsString)).setter(ListEventsFilters.setter(Builder::eventClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventClass").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(ListEventsFilters.getter(ListEventsFilters::eventSource)).setter(ListEventsFilters.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(ListEventsFilters.getter(ListEventsFilters::dataSourceAsString)).setter(ListEventsFilters.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ListEventsFilters.getter(ListEventsFilters::resourceCollection)).setter(ListEventsFilters.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD, EVENT_TIME_RANGE_FIELD, EVENT_CLASS_FIELD, EVENT_SOURCE_FIELD, DATA_SOURCE_FIELD, RESOURCE_COLLECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InsightId", INSIGHT_ID_FIELD);
            this.put("EventTimeRange", EVENT_TIME_RANGE_FIELD);
            this.put("EventClass", EVENT_CLASS_FIELD);
            this.put("EventSource", EVENT_SOURCE_FIELD);
            this.put("DataSource", DATA_SOURCE_FIELD);
            this.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String insightId;
    private final EventTimeRange eventTimeRange;
    private final String eventClass;
    private final String eventSource;
    private final String dataSource;
    private final ResourceCollection resourceCollection;

    private ListEventsFilters(BuilderImpl builder) {
        this.insightId = builder.insightId;
        this.eventTimeRange = builder.eventTimeRange;
        this.eventClass = builder.eventClass;
        this.eventSource = builder.eventSource;
        this.dataSource = builder.dataSource;
        this.resourceCollection = builder.resourceCollection;
    }

    public final String insightId() {
        return this.insightId;
    }

    public final EventTimeRange eventTimeRange() {
        return this.eventTimeRange;
    }

    public final EventClass eventClass() {
        return EventClass.fromValue(this.eventClass);
    }

    public final String eventClassAsString() {
        return this.eventClass;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final EventDataSource dataSource() {
        return EventDataSource.fromValue(this.dataSource);
    }

    public final String dataSourceAsString() {
        return this.dataSource;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventsFilters)) {
            return false;
        }
        ListEventsFilters other = (ListEventsFilters)obj;
        return Objects.equals(this.insightId(), other.insightId()) && Objects.equals(this.eventTimeRange(), other.eventTimeRange()) && Objects.equals(this.eventClassAsString(), other.eventClassAsString()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.resourceCollection(), other.resourceCollection());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventsFilters").add("InsightId", (Object)this.insightId()).add("EventTimeRange", (Object)this.eventTimeRange()).add("EventClass", (Object)this.eventClassAsString()).add("EventSource", (Object)this.eventSource()).add("DataSource", (Object)this.dataSourceAsString()).add("ResourceCollection", (Object)this.resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "EventTimeRange": {
                return Optional.ofNullable(clazz.cast(this.eventTimeRange()));
            }
            case "EventClass": {
                return Optional.ofNullable(clazz.cast(this.eventClassAsString()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEventsFilters, T> g) {
        return obj -> g.apply((ListEventsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightId;
        private EventTimeRange eventTimeRange;
        private String eventClass;
        private String eventSource;
        private String dataSource;
        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventsFilters model) {
            this.insightId(model.insightId);
            this.eventTimeRange(model.eventTimeRange);
            this.eventClass(model.eventClass);
            this.eventSource(model.eventSource);
            this.dataSource(model.dataSource);
            this.resourceCollection(model.resourceCollection);
        }

        public final String getInsightId() {
            return this.insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final EventTimeRange.Builder getEventTimeRange() {
            return this.eventTimeRange != null ? this.eventTimeRange.toBuilder() : null;
        }

        public final void setEventTimeRange(EventTimeRange.BuilderImpl eventTimeRange) {
            this.eventTimeRange = eventTimeRange != null ? eventTimeRange.build() : null;
        }

        @Override
        public final Builder eventTimeRange(EventTimeRange eventTimeRange) {
            this.eventTimeRange = eventTimeRange;
            return this;
        }

        public final String getEventClass() {
            return this.eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(EventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(EventDataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public ListEventsFilters build() {
            return new ListEventsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListEventsFilters> {
        public Builder insightId(String var1);

        public Builder eventTimeRange(EventTimeRange var1);

        default public Builder eventTimeRange(Consumer<EventTimeRange.Builder> eventTimeRange) {
            return this.eventTimeRange((EventTimeRange)((EventTimeRange.Builder)EventTimeRange.builder().applyMutation(eventTimeRange)).build());
        }

        public Builder eventClass(String var1);

        public Builder eventClass(EventClass var1);

        public Builder eventSource(String var1);

        public Builder dataSource(String var1);

        public Builder dataSource(EventDataSource var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }
    }
}

