/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange;
import software.amazon.awssdk.services.devopsguru.model.AnomalyResource;
import software.amazon.awssdk.services.devopsguru.model.AnomalyResourcesCopier;
import software.amazon.awssdk.services.devopsguru.model.AnomalySeverity;
import software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails;
import software.amazon.awssdk.services.devopsguru.model.AnomalyStatus;
import software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange;
import software.amazon.awssdk.services.devopsguru.model.AnomalyType;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReactiveAnomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReactiveAnomaly> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ReactiveAnomaly.getter(ReactiveAnomaly::id)).setter(ReactiveAnomaly.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ReactiveAnomaly.getter(ReactiveAnomaly::severityAsString)).setter(ReactiveAnomaly.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReactiveAnomaly.getter(ReactiveAnomaly::statusAsString)).setter(ReactiveAnomaly.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyTimeRange").getter(ReactiveAnomaly.getter(ReactiveAnomaly::anomalyTimeRange)).setter(ReactiveAnomaly.setter(Builder::anomalyTimeRange)).constructor(AnomalyTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()}).build();
    private static final SdkField<AnomalyReportedTimeRange> ANOMALY_REPORTED_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyReportedTimeRange").getter(ReactiveAnomaly.getter(ReactiveAnomaly::anomalyReportedTimeRange)).setter(ReactiveAnomaly.setter(Builder::anomalyReportedTimeRange)).constructor(AnomalyReportedTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyReportedTimeRange").build()}).build();
    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDetails").getter(ReactiveAnomaly.getter(ReactiveAnomaly::sourceDetails)).setter(ReactiveAnomaly.setter(Builder::sourceDetails)).constructor(AnomalySourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()}).build();
    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedInsightId").getter(ReactiveAnomaly.getter(ReactiveAnomaly::associatedInsightId)).setter(ReactiveAnomaly.setter(Builder::associatedInsightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ReactiveAnomaly.getter(ReactiveAnomaly::resourceCollection)).setter(ReactiveAnomaly.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ReactiveAnomaly.getter(ReactiveAnomaly::typeAsString)).setter(ReactiveAnomaly.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ReactiveAnomaly.getter(ReactiveAnomaly::name)).setter(ReactiveAnomaly.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReactiveAnomaly.getter(ReactiveAnomaly::description)).setter(ReactiveAnomaly.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CAUSAL_ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CausalAnomalyId").getter(ReactiveAnomaly.getter(ReactiveAnomaly::causalAnomalyId)).setter(ReactiveAnomaly.setter(Builder::causalAnomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CausalAnomalyId").build()}).build();
    private static final SdkField<List<AnomalyResource>> ANOMALY_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyResources").getter(ReactiveAnomaly.getter(ReactiveAnomaly::anomalyResources)).setter(ReactiveAnomaly.setter(Builder::anomalyResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, ANOMALY_TIME_RANGE_FIELD, ANOMALY_REPORTED_TIME_RANGE_FIELD, SOURCE_DETAILS_FIELD, ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD, TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CAUSAL_ANOMALY_ID_FIELD, ANOMALY_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReactiveAnomaly.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String severity;
    private final String status;
    private final AnomalyTimeRange anomalyTimeRange;
    private final AnomalyReportedTimeRange anomalyReportedTimeRange;
    private final AnomalySourceDetails sourceDetails;
    private final String associatedInsightId;
    private final ResourceCollection resourceCollection;
    private final String type;
    private final String name;
    private final String description;
    private final String causalAnomalyId;
    private final List<AnomalyResource> anomalyResources;

    private ReactiveAnomaly(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.anomalyReportedTimeRange = builder.anomalyReportedTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.causalAnomalyId = builder.causalAnomalyId;
        this.anomalyResources = builder.anomalyResources;
    }

    public final String id() {
        return this.id;
    }

    public final AnomalySeverity severity() {
        return AnomalySeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final AnomalyStatus status() {
        return AnomalyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AnomalyTimeRange anomalyTimeRange() {
        return this.anomalyTimeRange;
    }

    public final AnomalyReportedTimeRange anomalyReportedTimeRange() {
        return this.anomalyReportedTimeRange;
    }

    public final AnomalySourceDetails sourceDetails() {
        return this.sourceDetails;
    }

    public final String associatedInsightId() {
        return this.associatedInsightId;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public final AnomalyType type() {
        return AnomalyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String causalAnomalyId() {
        return this.causalAnomalyId;
    }

    public final boolean hasAnomalyResources() {
        return this.anomalyResources != null && !(this.anomalyResources instanceof SdkAutoConstructList);
    }

    public final List<AnomalyResource> anomalyResources() {
        return this.anomalyResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyReportedTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.causalAnomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyResources() ? this.anomalyResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveAnomaly)) {
            return false;
        }
        ReactiveAnomaly other = (ReactiveAnomaly)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.anomalyTimeRange(), other.anomalyTimeRange()) && Objects.equals(this.anomalyReportedTimeRange(), other.anomalyReportedTimeRange()) && Objects.equals(this.sourceDetails(), other.sourceDetails()) && Objects.equals(this.associatedInsightId(), other.associatedInsightId()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.causalAnomalyId(), other.causalAnomalyId()) && this.hasAnomalyResources() == other.hasAnomalyResources() && Objects.equals(this.anomalyResources(), other.anomalyResources());
    }

    public final String toString() {
        return ToString.builder((String)"ReactiveAnomaly").add("Id", (Object)this.id()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("AnomalyTimeRange", (Object)this.anomalyTimeRange()).add("AnomalyReportedTimeRange", (Object)this.anomalyReportedTimeRange()).add("SourceDetails", (Object)this.sourceDetails()).add("AssociatedInsightId", (Object)this.associatedInsightId()).add("ResourceCollection", (Object)this.resourceCollection()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CausalAnomalyId", (Object)this.causalAnomalyId()).add("AnomalyResources", this.hasAnomalyResources() ? this.anomalyResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AnomalyTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyTimeRange()));
            }
            case "AnomalyReportedTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyReportedTimeRange()));
            }
            case "SourceDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceDetails()));
            }
            case "AssociatedInsightId": {
                return Optional.ofNullable(clazz.cast(this.associatedInsightId()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CausalAnomalyId": {
                return Optional.ofNullable(clazz.cast(this.causalAnomalyId()));
            }
            case "AnomalyResources": {
                return Optional.ofNullable(clazz.cast(this.anomalyResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AnomalyTimeRange", ANOMALY_TIME_RANGE_FIELD);
        map.put("AnomalyReportedTimeRange", ANOMALY_REPORTED_TIME_RANGE_FIELD);
        map.put("SourceDetails", SOURCE_DETAILS_FIELD);
        map.put("AssociatedInsightId", ASSOCIATED_INSIGHT_ID_FIELD);
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CausalAnomalyId", CAUSAL_ANOMALY_ID_FIELD);
        map.put("AnomalyResources", ANOMALY_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReactiveAnomaly, T> g) {
        return obj -> g.apply((ReactiveAnomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String severity;
        private String status;
        private AnomalyTimeRange anomalyTimeRange;
        private AnomalyReportedTimeRange anomalyReportedTimeRange;
        private AnomalySourceDetails sourceDetails;
        private String associatedInsightId;
        private ResourceCollection resourceCollection;
        private String type;
        private String name;
        private String description;
        private String causalAnomalyId;
        private List<AnomalyResource> anomalyResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveAnomaly model) {
            this.id(model.id);
            this.severity(model.severity);
            this.status(model.status);
            this.anomalyTimeRange(model.anomalyTimeRange);
            this.anomalyReportedTimeRange(model.anomalyReportedTimeRange);
            this.sourceDetails(model.sourceDetails);
            this.associatedInsightId(model.associatedInsightId);
            this.resourceCollection(model.resourceCollection);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.causalAnomalyId(model.causalAnomalyId);
            this.anomalyResources(model.anomalyResources);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return this.anomalyTimeRange != null ? this.anomalyTimeRange.toBuilder() : null;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final AnomalyReportedTimeRange.Builder getAnomalyReportedTimeRange() {
            return this.anomalyReportedTimeRange != null ? this.anomalyReportedTimeRange.toBuilder() : null;
        }

        public final void setAnomalyReportedTimeRange(AnomalyReportedTimeRange.BuilderImpl anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange != null ? anomalyReportedTimeRange.build() : null;
        }

        @Override
        public final Builder anomalyReportedTimeRange(AnomalyReportedTimeRange anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange;
            return this;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return this.sourceDetails != null ? this.sourceDetails.toBuilder() : null;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final String getAssociatedInsightId() {
            return this.associatedInsightId;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnomalyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCausalAnomalyId() {
            return this.causalAnomalyId;
        }

        public final void setCausalAnomalyId(String causalAnomalyId) {
            this.causalAnomalyId = causalAnomalyId;
        }

        @Override
        public final Builder causalAnomalyId(String causalAnomalyId) {
            this.causalAnomalyId = causalAnomalyId;
            return this;
        }

        public final List<AnomalyResource.Builder> getAnomalyResources() {
            List<AnomalyResource.Builder> result = AnomalyResourcesCopier.copyToBuilder(this.anomalyResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyResources(Collection<AnomalyResource.BuilderImpl> anomalyResources) {
            this.anomalyResources = AnomalyResourcesCopier.copyFromBuilder(anomalyResources);
        }

        @Override
        public final Builder anomalyResources(Collection<AnomalyResource> anomalyResources) {
            this.anomalyResources = AnomalyResourcesCopier.copy(anomalyResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyResources(AnomalyResource ... anomalyResources) {
            this.anomalyResources(Arrays.asList(anomalyResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyResources(Consumer<AnomalyResource.Builder> ... anomalyResources) {
            this.anomalyResources(Stream.of(anomalyResources).map(c -> (AnomalyResource)((AnomalyResource.Builder)AnomalyResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReactiveAnomaly build() {
            return new ReactiveAnomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReactiveAnomaly> {
        public Builder id(String var1);

        public Builder severity(String var1);

        public Builder severity(AnomalySeverity var1);

        public Builder status(String var1);

        public Builder status(AnomalyStatus var1);

        public Builder anomalyTimeRange(AnomalyTimeRange var1);

        default public Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return this.anomalyTimeRange((AnomalyTimeRange)((AnomalyTimeRange.Builder)AnomalyTimeRange.builder().applyMutation(anomalyTimeRange)).build());
        }

        public Builder anomalyReportedTimeRange(AnomalyReportedTimeRange var1);

        default public Builder anomalyReportedTimeRange(Consumer<AnomalyReportedTimeRange.Builder> anomalyReportedTimeRange) {
            return this.anomalyReportedTimeRange((AnomalyReportedTimeRange)((AnomalyReportedTimeRange.Builder)AnomalyReportedTimeRange.builder().applyMutation(anomalyReportedTimeRange)).build());
        }

        public Builder sourceDetails(AnomalySourceDetails var1);

        default public Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return this.sourceDetails((AnomalySourceDetails)((AnomalySourceDetails.Builder)AnomalySourceDetails.builder().applyMutation(sourceDetails)).build());
        }

        public Builder associatedInsightId(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder type(String var1);

        public Builder type(AnomalyType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder causalAnomalyId(String var1);

        public Builder anomalyResources(Collection<AnomalyResource> var1);

        public Builder anomalyResources(AnomalyResource ... var1);

        public Builder anomalyResources(Consumer<AnomalyResource.Builder> ... var1);
    }
}

