/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.UpdateCloudFormationCollectionFilter;
import software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFilter;
import software.amazon.awssdk.services.devopsguru.model.UpdateTagCollectionFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceCollectionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateResourceCollectionFilter> {
    private static final SdkField<UpdateCloudFormationCollectionFilter> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFormation").getter(UpdateResourceCollectionFilter.getter(UpdateResourceCollectionFilter::cloudFormation)).setter(UpdateResourceCollectionFilter.setter(Builder::cloudFormation)).constructor(UpdateCloudFormationCollectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()}).build();
    private static final SdkField<List<UpdateTagCollectionFilter>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(UpdateResourceCollectionFilter.getter(UpdateResourceCollectionFilter::tags)).setter(UpdateResourceCollectionFilter.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateTagCollectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudFormation", CLOUD_FORMATION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final UpdateCloudFormationCollectionFilter cloudFormation;
    private final List<UpdateTagCollectionFilter> tags;

    private UpdateResourceCollectionFilter(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.tags = builder.tags;
    }

    public final UpdateCloudFormationCollectionFilter cloudFormation() {
        return this.cloudFormation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<UpdateTagCollectionFilter> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceCollectionFilter)) {
            return false;
        }
        UpdateResourceCollectionFilter other = (UpdateResourceCollectionFilter)obj;
        return Objects.equals(this.cloudFormation(), other.cloudFormation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceCollectionFilter").add("CloudFormation", (Object)this.cloudFormation()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceCollectionFilter, T> g) {
        return obj -> g.apply((UpdateResourceCollectionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UpdateCloudFormationCollectionFilter cloudFormation;
        private List<UpdateTagCollectionFilter> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceCollectionFilter model) {
            this.cloudFormation(model.cloudFormation);
            this.tags(model.tags);
        }

        public final UpdateCloudFormationCollectionFilter.Builder getCloudFormation() {
            return this.cloudFormation != null ? this.cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(UpdateCloudFormationCollectionFilter.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public final Builder cloudFormation(UpdateCloudFormationCollectionFilter cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final List<UpdateTagCollectionFilter.Builder> getTags() {
            List<UpdateTagCollectionFilter.Builder> result = UpdateTagCollectionFiltersCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<UpdateTagCollectionFilter.BuilderImpl> tags) {
            this.tags = UpdateTagCollectionFiltersCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<UpdateTagCollectionFilter> tags) {
            this.tags = UpdateTagCollectionFiltersCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(UpdateTagCollectionFilter ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<UpdateTagCollectionFilter.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (UpdateTagCollectionFilter)((UpdateTagCollectionFilter.Builder)UpdateTagCollectionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpdateResourceCollectionFilter build() {
            return new UpdateResourceCollectionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateResourceCollectionFilter> {
        public Builder cloudFormation(UpdateCloudFormationCollectionFilter var1);

        default public Builder cloudFormation(Consumer<UpdateCloudFormationCollectionFilter.Builder> cloudFormation) {
            return this.cloudFormation((UpdateCloudFormationCollectionFilter)((UpdateCloudFormationCollectionFilter.Builder)UpdateCloudFormationCollectionFilter.builder().applyMutation(cloudFormation)).build());
        }

        public Builder tags(Collection<UpdateTagCollectionFilter> var1);

        public Builder tags(UpdateTagCollectionFilter ... var1);

        public Builder tags(Consumer<UpdateTagCollectionFilter.Builder> ... var1);
    }
}

