/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventSourcesConfigRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, UpdateEventSourcesConfigRequest> {
    private static final SdkField<EventSourcesConfig> EVENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventSources").getter(UpdateEventSourcesConfigRequest.getter(UpdateEventSourcesConfigRequest::eventSources)).setter(UpdateEventSourcesConfigRequest.setter(Builder::eventSources)).constructor(EventSourcesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventSources", EVENT_SOURCES_FIELD);
        }
    });
    private final EventSourcesConfig eventSources;

    private UpdateEventSourcesConfigRequest(BuilderImpl builder) {
        super(builder);
        this.eventSources = builder.eventSources;
    }

    public final EventSourcesConfig eventSources() {
        return this.eventSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourcesConfigRequest)) {
            return false;
        }
        UpdateEventSourcesConfigRequest other = (UpdateEventSourcesConfigRequest)((Object)obj);
        return Objects.equals(this.eventSources(), other.eventSources());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventSourcesConfigRequest").add("EventSources", (Object)this.eventSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSources": {
                return Optional.ofNullable(clazz.cast(this.eventSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourcesConfigRequest, T> g) {
        return obj -> g.apply((UpdateEventSourcesConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private EventSourcesConfig eventSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourcesConfigRequest model) {
            super(model);
            this.eventSources(model.eventSources);
        }

        public final EventSourcesConfig.Builder getEventSources() {
            return this.eventSources != null ? this.eventSources.toBuilder() : null;
        }

        public final void setEventSources(EventSourcesConfig.BuilderImpl eventSources) {
            this.eventSources = eventSources != null ? eventSources.build() : null;
        }

        @Override
        public final Builder eventSources(EventSourcesConfig eventSources) {
            this.eventSources = eventSources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourcesConfigRequest build() {
            return new UpdateEventSourcesConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventSourcesConfigRequest> {
        public Builder eventSources(EventSourcesConfig var1);

        default public Builder eventSources(Consumer<EventSourcesConfig.Builder> eventSources) {
            return this.eventSources((EventSourcesConfig)((EventSourcesConfig.Builder)EventSourcesConfig.builder().applyMutation(eventSources)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

