/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.LogAnomalyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogAnomalyClass
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogAnomalyClass> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStreamName").getter(LogAnomalyClass.getter(LogAnomalyClass::logStreamName)).setter(LogAnomalyClass.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamName").build()}).build();
    private static final SdkField<String> LOG_ANOMALY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogAnomalyType").getter(LogAnomalyClass.getter(LogAnomalyClass::logAnomalyTypeAsString)).setter(LogAnomalyClass.setter(Builder::logAnomalyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyType").build()}).build();
    private static final SdkField<String> LOG_ANOMALY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogAnomalyToken").getter(LogAnomalyClass.getter(LogAnomalyClass::logAnomalyToken)).setter(LogAnomalyClass.setter(Builder::logAnomalyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyToken").build()}).build();
    private static final SdkField<String> LOG_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogEventId").getter(LogAnomalyClass.getter(LogAnomalyClass::logEventId)).setter(LogAnomalyClass.setter(Builder::logEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEventId").build()}).build();
    private static final SdkField<String> EXPLANATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Explanation").getter(LogAnomalyClass.getter(LogAnomalyClass::explanation)).setter(LogAnomalyClass.setter(Builder::explanation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explanation").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_LOG_LINES_OCCURRENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfLogLinesOccurrences").getter(LogAnomalyClass.getter(LogAnomalyClass::numberOfLogLinesOccurrences)).setter(LogAnomalyClass.setter(Builder::numberOfLogLinesOccurrences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLogLinesOccurrences").build()}).build();
    private static final SdkField<Instant> LOG_EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LogEventTimestamp").getter(LogAnomalyClass.getter(LogAnomalyClass::logEventTimestamp)).setter(LogAnomalyClass.setter(Builder::logEventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEventTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD, LOG_ANOMALY_TYPE_FIELD, LOG_ANOMALY_TOKEN_FIELD, LOG_EVENT_ID_FIELD, EXPLANATION_FIELD, NUMBER_OF_LOG_LINES_OCCURRENCES_FIELD, LOG_EVENT_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logStreamName;
    private final String logAnomalyType;
    private final String logAnomalyToken;
    private final String logEventId;
    private final String explanation;
    private final Integer numberOfLogLinesOccurrences;
    private final Instant logEventTimestamp;

    private LogAnomalyClass(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.logAnomalyType = builder.logAnomalyType;
        this.logAnomalyToken = builder.logAnomalyToken;
        this.logEventId = builder.logEventId;
        this.explanation = builder.explanation;
        this.numberOfLogLinesOccurrences = builder.numberOfLogLinesOccurrences;
        this.logEventTimestamp = builder.logEventTimestamp;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final LogAnomalyType logAnomalyType() {
        return LogAnomalyType.fromValue(this.logAnomalyType);
    }

    public final String logAnomalyTypeAsString() {
        return this.logAnomalyType;
    }

    public final String logAnomalyToken() {
        return this.logAnomalyToken;
    }

    public final String logEventId() {
        return this.logEventId;
    }

    public final String explanation() {
        return this.explanation;
    }

    public final Integer numberOfLogLinesOccurrences() {
        return this.numberOfLogLinesOccurrences;
    }

    public final Instant logEventTimestamp() {
        return this.logEventTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logAnomalyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logAnomalyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.logEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.explanation());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLogLinesOccurrences());
        hashCode = 31 * hashCode + Objects.hashCode(this.logEventTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogAnomalyClass)) {
            return false;
        }
        LogAnomalyClass other = (LogAnomalyClass)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.logAnomalyTypeAsString(), other.logAnomalyTypeAsString()) && Objects.equals(this.logAnomalyToken(), other.logAnomalyToken()) && Objects.equals(this.logEventId(), other.logEventId()) && Objects.equals(this.explanation(), other.explanation()) && Objects.equals(this.numberOfLogLinesOccurrences(), other.numberOfLogLinesOccurrences()) && Objects.equals(this.logEventTimestamp(), other.logEventTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"LogAnomalyClass").add("LogStreamName", (Object)this.logStreamName()).add("LogAnomalyType", (Object)this.logAnomalyTypeAsString()).add("LogAnomalyToken", (Object)this.logAnomalyToken()).add("LogEventId", (Object)this.logEventId()).add("Explanation", (Object)this.explanation()).add("NumberOfLogLinesOccurrences", (Object)this.numberOfLogLinesOccurrences()).add("LogEventTimestamp", (Object)this.logEventTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "LogAnomalyType": {
                return Optional.ofNullable(clazz.cast(this.logAnomalyTypeAsString()));
            }
            case "LogAnomalyToken": {
                return Optional.ofNullable(clazz.cast(this.logAnomalyToken()));
            }
            case "LogEventId": {
                return Optional.ofNullable(clazz.cast(this.logEventId()));
            }
            case "Explanation": {
                return Optional.ofNullable(clazz.cast(this.explanation()));
            }
            case "NumberOfLogLinesOccurrences": {
                return Optional.ofNullable(clazz.cast(this.numberOfLogLinesOccurrences()));
            }
            case "LogEventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.logEventTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogAnomalyClass, T> g) {
        return obj -> g.apply((LogAnomalyClass)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private String logAnomalyType;
        private String logAnomalyToken;
        private String logEventId;
        private String explanation;
        private Integer numberOfLogLinesOccurrences;
        private Instant logEventTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(LogAnomalyClass model) {
            this.logStreamName(model.logStreamName);
            this.logAnomalyType(model.logAnomalyType);
            this.logAnomalyToken(model.logAnomalyToken);
            this.logEventId(model.logEventId);
            this.explanation(model.explanation);
            this.numberOfLogLinesOccurrences(model.numberOfLogLinesOccurrences);
            this.logEventTimestamp(model.logEventTimestamp);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final String getLogAnomalyType() {
            return this.logAnomalyType;
        }

        public final void setLogAnomalyType(String logAnomalyType) {
            this.logAnomalyType = logAnomalyType;
        }

        @Override
        public final Builder logAnomalyType(String logAnomalyType) {
            this.logAnomalyType = logAnomalyType;
            return this;
        }

        @Override
        public final Builder logAnomalyType(LogAnomalyType logAnomalyType) {
            this.logAnomalyType(logAnomalyType == null ? null : logAnomalyType.toString());
            return this;
        }

        public final String getLogAnomalyToken() {
            return this.logAnomalyToken;
        }

        public final void setLogAnomalyToken(String logAnomalyToken) {
            this.logAnomalyToken = logAnomalyToken;
        }

        @Override
        public final Builder logAnomalyToken(String logAnomalyToken) {
            this.logAnomalyToken = logAnomalyToken;
            return this;
        }

        public final String getLogEventId() {
            return this.logEventId;
        }

        public final void setLogEventId(String logEventId) {
            this.logEventId = logEventId;
        }

        @Override
        public final Builder logEventId(String logEventId) {
            this.logEventId = logEventId;
            return this;
        }

        public final String getExplanation() {
            return this.explanation;
        }

        public final void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        @Override
        public final Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public final Integer getNumberOfLogLinesOccurrences() {
            return this.numberOfLogLinesOccurrences;
        }

        public final void setNumberOfLogLinesOccurrences(Integer numberOfLogLinesOccurrences) {
            this.numberOfLogLinesOccurrences = numberOfLogLinesOccurrences;
        }

        @Override
        public final Builder numberOfLogLinesOccurrences(Integer numberOfLogLinesOccurrences) {
            this.numberOfLogLinesOccurrences = numberOfLogLinesOccurrences;
            return this;
        }

        public final Instant getLogEventTimestamp() {
            return this.logEventTimestamp;
        }

        public final void setLogEventTimestamp(Instant logEventTimestamp) {
            this.logEventTimestamp = logEventTimestamp;
        }

        @Override
        public final Builder logEventTimestamp(Instant logEventTimestamp) {
            this.logEventTimestamp = logEventTimestamp;
            return this;
        }

        public LogAnomalyClass build() {
            return new LogAnomalyClass(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogAnomalyClass> {
        public Builder logStreamName(String var1);

        public Builder logAnomalyType(String var1);

        public Builder logAnomalyType(LogAnomalyType var1);

        public Builder logAnomalyToken(String var1);

        public Builder logEventId(String var1);

        public Builder explanation(String var1);

        public Builder numberOfLogLinesOccurrences(Integer var1);

        public Builder logEventTimestamp(Instant var1);
    }
}

