/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.OptInStatus;
import software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KMSServerSideEncryptionIntegration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KMSServerSideEncryptionIntegration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(KMSServerSideEncryptionIntegration.getter(KMSServerSideEncryptionIntegration::kmsKeyId)).setter(KMSServerSideEncryptionIntegration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInStatus").getter(KMSServerSideEncryptionIntegration.getter(KMSServerSideEncryptionIntegration::optInStatusAsString)).setter(KMSServerSideEncryptionIntegration.setter(Builder::optInStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(KMSServerSideEncryptionIntegration.getter(KMSServerSideEncryptionIntegration::typeAsString)).setter(KMSServerSideEncryptionIntegration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, OPT_IN_STATUS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String optInStatus;
    private final String type;

    private KMSServerSideEncryptionIntegration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.optInStatus = builder.optInStatus;
        this.type = builder.type;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final OptInStatus optInStatus() {
        return OptInStatus.fromValue(this.optInStatus);
    }

    public final String optInStatusAsString() {
        return this.optInStatus;
    }

    public final ServerSideEncryptionType type() {
        return ServerSideEncryptionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSServerSideEncryptionIntegration)) {
            return false;
        }
        KMSServerSideEncryptionIntegration other = (KMSServerSideEncryptionIntegration)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.optInStatusAsString(), other.optInStatusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KMSServerSideEncryptionIntegration").add("KMSKeyId", (Object)this.kmsKeyId()).add("OptInStatus", (Object)this.optInStatusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OptInStatus": {
                return Optional.ofNullable(clazz.cast(this.optInStatusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KMSServerSideEncryptionIntegration, T> g) {
        return obj -> g.apply((KMSServerSideEncryptionIntegration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String optInStatus;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSServerSideEncryptionIntegration model) {
            this.kmsKeyId(model.kmsKeyId);
            this.optInStatus(model.optInStatus);
            this.type(model.type);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOptInStatus() {
            return this.optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(OptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServerSideEncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public KMSServerSideEncryptionIntegration build() {
            return new KMSServerSideEncryptionIntegration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KMSServerSideEncryptionIntegration> {
        public Builder kmsKeyId(String var1);

        public Builder optInStatus(String var1);

        public Builder optInStatus(OptInStatus var1);

        public Builder type(String var1);

        public Builder type(ServerSideEncryptionType var1);
    }
}

