/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventSourcesConfigRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<UpdateEventSourcesConfigRequest.Builder, UpdateEventSourcesConfigRequest> {
    private static final SdkField<EventSourcesConfig> EVENT_SOURCES_FIELD = SdkField
            .<EventSourcesConfig> builder(MarshallingType.SDK_POJO).memberName("EventSources")
            .getter(getter(UpdateEventSourcesConfigRequest::eventSources)).setter(setter(Builder::eventSources))
            .constructor(EventSourcesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD));

    private final EventSourcesConfig eventSources;

    private UpdateEventSourcesConfigRequest(BuilderImpl builder) {
        super(builder);
        this.eventSources = builder.eventSources;
    }

    /**
     * <p>
     * Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS
     * Service.
     * </p>
     * 
     * @return Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with
     *         another AWS Service.
     */
    public final EventSourcesConfig eventSources() {
        return eventSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourcesConfigRequest)) {
            return false;
        }
        UpdateEventSourcesConfigRequest other = (UpdateEventSourcesConfigRequest) obj;
        return Objects.equals(eventSources(), other.eventSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventSourcesConfigRequest").add("EventSources", eventSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSources":
            return Optional.ofNullable(clazz.cast(eventSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourcesConfigRequest, T> g) {
        return obj -> g.apply((UpdateEventSourcesConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEventSourcesConfigRequest> {
        /**
         * <p>
         * Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another
         * AWS Service.
         * </p>
         * 
         * @param eventSources
         *        Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with
         *        another AWS Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSources(EventSourcesConfig eventSources);

        /**
         * <p>
         * Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another
         * AWS Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSourcesConfig.Builder} avoiding the
         * need to create one manually via {@link EventSourcesConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSourcesConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #eventSources(EventSourcesConfig)}.
         * 
         * @param eventSources
         *        a consumer that will call methods on {@link EventSourcesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSources(EventSourcesConfig)
         */
        default Builder eventSources(Consumer<EventSourcesConfig.Builder> eventSources) {
            return eventSources(EventSourcesConfig.builder().applyMutation(eventSources).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private EventSourcesConfig eventSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourcesConfigRequest model) {
            super(model);
            eventSources(model.eventSources);
        }

        public final EventSourcesConfig.Builder getEventSources() {
            return eventSources != null ? eventSources.toBuilder() : null;
        }

        public final void setEventSources(EventSourcesConfig.BuilderImpl eventSources) {
            this.eventSources = eventSources != null ? eventSources.build() : null;
        }

        @Override
        public final Builder eventSources(EventSourcesConfig eventSources) {
            this.eventSources = eventSources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourcesConfigRequest build() {
            return new UpdateEventSourcesConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
