/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ServiceName {
    API_GATEWAY("API_GATEWAY"),

    APPLICATION_ELB("APPLICATION_ELB"),

    AUTO_SCALING_GROUP("AUTO_SCALING_GROUP"),

    CLOUD_FRONT("CLOUD_FRONT"),

    DYNAMO_DB("DYNAMO_DB"),

    EC2("EC2"),

    ECS("ECS"),

    EKS("EKS"),

    ELASTIC_BEANSTALK("ELASTIC_BEANSTALK"),

    ELASTI_CACHE("ELASTI_CACHE"),

    ELB("ELB"),

    ES("ES"),

    KINESIS("KINESIS"),

    LAMBDA("LAMBDA"),

    NAT_GATEWAY("NAT_GATEWAY"),

    NETWORK_ELB("NETWORK_ELB"),

    RDS("RDS"),

    REDSHIFT("REDSHIFT"),

    ROUTE_53("ROUTE_53"),

    S3("S3"),

    SAGE_MAKER("SAGE_MAKER"),

    SNS("SNS"),

    SQS("SQS"),

    STEP_FUNCTIONS("STEP_FUNCTIONS"),

    SWF("SWF"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceName> VALUE_MAP = EnumUtils.uniqueIndex(ServiceName.class, ServiceName::toString);

    private final String value;

    private ServiceName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ServiceName corresponding to the value
     */
    public static ServiceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ServiceName}s
     */
    public static Set<ServiceName> knownValues() {
        Set<ServiceName> knownValues = EnumSet.allOf(ServiceName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
