/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchInsightsRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<SearchInsightsRequest.Builder, SearchInsightsRequest> {
    private static final SdkField<StartTimeRange> START_TIME_RANGE_FIELD = SdkField
            .<StartTimeRange> builder(MarshallingType.SDK_POJO).memberName("StartTimeRange")
            .getter(getter(SearchInsightsRequest::startTimeRange)).setter(setter(Builder::startTimeRange))
            .constructor(StartTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeRange").build()).build();

    private static final SdkField<SearchInsightsFilters> FILTERS_FIELD = SdkField
            .<SearchInsightsFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(SearchInsightsRequest::filters)).setter(setter(Builder::filters))
            .constructor(SearchInsightsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchInsightsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchInsightsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SearchInsightsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_RANGE_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TYPE_FIELD));

    private final StartTimeRange startTimeRange;

    private final SearchInsightsFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String type;

    private SearchInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.startTimeRange = builder.startTimeRange;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.type = builder.type;
    }

    /**
     * <p>
     * The start of the time range passed in. Returned insights occurred after this time.
     * </p>
     * 
     * @return The start of the time range passed in. Returned insights occurred after this time.
     */
    public final StartTimeRange startTimeRange() {
        return startTimeRange;
    }

    /**
     * <p>
     * A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight
     * search.
     * </p>
     * 
     * @return A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your
     *         insight search.
     */
    public final SearchInsightsFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
     * @see InsightType
     */
    public final InsightType type() {
        return InsightType.fromValue(type);
    }

    /**
     * <p>
     * The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
     * @see InsightType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInsightsRequest)) {
            return false;
        }
        SearchInsightsRequest other = (SearchInsightsRequest) obj;
        return Objects.equals(startTimeRange(), other.startTimeRange()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchInsightsRequest").add("StartTimeRange", startTimeRange()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTimeRange":
            return Optional.ofNullable(clazz.cast(startTimeRange()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchInsightsRequest, T> g) {
        return obj -> g.apply((SearchInsightsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchInsightsRequest> {
        /**
         * <p>
         * The start of the time range passed in. Returned insights occurred after this time.
         * </p>
         * 
         * @param startTimeRange
         *        The start of the time range passed in. Returned insights occurred after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeRange(StartTimeRange startTimeRange);

        /**
         * <p>
         * The start of the time range passed in. Returned insights occurred after this time.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartTimeRange.Builder} avoiding the need
         * to create one manually via {@link StartTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #startTimeRange(StartTimeRange)}.
         * 
         * @param startTimeRange
         *        a consumer that will call methods on {@link StartTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeRange(StartTimeRange)
         */
        default Builder startTimeRange(Consumer<StartTimeRange.Builder> startTimeRange) {
            return startTimeRange(StartTimeRange.builder().applyMutation(startTimeRange).build());
        }

        /**
         * <p>
         * A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your
         * insight search.
         * </p>
         * 
         * @param filters
         *        A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on
         *        your insight search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchInsightsFilters filters);

        /**
         * <p>
         * A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your
         * insight search.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchInsightsFilters.Builder} avoiding
         * the need to create one manually via {@link SearchInsightsFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchInsightsFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(SearchInsightsFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SearchInsightsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SearchInsightsFilters)
         */
        default Builder filters(Consumer<SearchInsightsFilters.Builder> filters) {
            return filters(SearchInsightsFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
         * </p>
         * 
         * @param type
         *        The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
         * </p>
         * 
         * @param type
         *        The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>).
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder type(InsightType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private StartTimeRange startTimeRange;

        private SearchInsightsFilters filters;

        private Integer maxResults;

        private String nextToken;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInsightsRequest model) {
            super(model);
            startTimeRange(model.startTimeRange);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            type(model.type);
        }

        public final StartTimeRange.Builder getStartTimeRange() {
            return startTimeRange != null ? startTimeRange.toBuilder() : null;
        }

        public final void setStartTimeRange(StartTimeRange.BuilderImpl startTimeRange) {
            this.startTimeRange = startTimeRange != null ? startTimeRange.build() : null;
        }

        @Override
        public final Builder startTimeRange(StartTimeRange startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        public final SearchInsightsFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SearchInsightsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchInsightsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InsightType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchInsightsRequest build() {
            return new SearchInsightsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
