/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reference data used to evaluate Performance Insights to determine if its performance is anomalous or not.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceInsightsReferenceData implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceInsightsReferenceData.Builder, PerformanceInsightsReferenceData> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PerformanceInsightsReferenceData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PerformanceInsightsReferenceComparisonValues> COMPARISON_VALUES_FIELD = SdkField
            .<PerformanceInsightsReferenceComparisonValues> builder(MarshallingType.SDK_POJO).memberName("ComparisonValues")
            .getter(getter(PerformanceInsightsReferenceData::comparisonValues)).setter(setter(Builder::comparisonValues))
            .constructor(PerformanceInsightsReferenceComparisonValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            COMPARISON_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final PerformanceInsightsReferenceComparisonValues comparisonValues;

    private PerformanceInsightsReferenceData(BuilderImpl builder) {
        this.name = builder.name;
        this.comparisonValues = builder.comparisonValues;
    }

    /**
     * <p>
     * The name of the reference data.
     * </p>
     * 
     * @return The name of the reference data.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The specific reference values used to evaluate the Performance Insights. For more information, see
     * <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>
     * .
     * </p>
     * 
     * @return The specific reference values used to evaluate the Performance Insights. For more information, see
     *         <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>
     *         .
     */
    public final PerformanceInsightsReferenceComparisonValues comparisonValues() {
        return comparisonValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsReferenceData)) {
            return false;
        }
        PerformanceInsightsReferenceData other = (PerformanceInsightsReferenceData) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(comparisonValues(), other.comparisonValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceInsightsReferenceData").add("Name", name())
                .add("ComparisonValues", comparisonValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ComparisonValues":
            return Optional.ofNullable(clazz.cast(comparisonValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsReferenceData, T> g) {
        return obj -> g.apply((PerformanceInsightsReferenceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceInsightsReferenceData> {
        /**
         * <p>
         * The name of the reference data.
         * </p>
         * 
         * @param name
         *        The name of the reference data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The specific reference values used to evaluate the Performance Insights. For more information, see
         * <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>
         * .
         * </p>
         * 
         * @param comparisonValues
         *        The specific reference values used to evaluate the Performance Insights. For more information, see
         *        <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonValues(PerformanceInsightsReferenceComparisonValues comparisonValues);

        /**
         * <p>
         * The specific reference values used to evaluate the Performance Insights. For more information, see
         * <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PerformanceInsightsReferenceComparisonValues.Builder} avoiding the need to create one manually via
         * {@link PerformanceInsightsReferenceComparisonValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsReferenceComparisonValues.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #comparisonValues(PerformanceInsightsReferenceComparisonValues)}.
         * 
         * @param comparisonValues
         *        a consumer that will call methods on {@link PerformanceInsightsReferenceComparisonValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonValues(PerformanceInsightsReferenceComparisonValues)
         */
        default Builder comparisonValues(Consumer<PerformanceInsightsReferenceComparisonValues.Builder> comparisonValues) {
            return comparisonValues(PerformanceInsightsReferenceComparisonValues.builder().applyMutation(comparisonValues)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private PerformanceInsightsReferenceComparisonValues comparisonValues;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsReferenceData model) {
            name(model.name);
            comparisonValues(model.comparisonValues);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PerformanceInsightsReferenceComparisonValues.Builder getComparisonValues() {
            return comparisonValues != null ? comparisonValues.toBuilder() : null;
        }

        public final void setComparisonValues(PerformanceInsightsReferenceComparisonValues.BuilderImpl comparisonValues) {
            this.comparisonValues = comparisonValues != null ? comparisonValues.build() : null;
        }

        @Override
        public final Builder comparisonValues(PerformanceInsightsReferenceComparisonValues comparisonValues) {
            this.comparisonValues = comparisonValues;
            return this;
        }

        @Override
        public PerformanceInsightsReferenceData build() {
            return new PerformanceInsightsReferenceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
