/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum LogAnomalyType {
    KEYWORD("KEYWORD"),

    KEYWORD_TOKEN("KEYWORD_TOKEN"),

    FORMAT("FORMAT"),

    HTTP_CODE("HTTP_CODE"),

    BLOCK_FORMAT("BLOCK_FORMAT"),

    NUMERICAL_POINT("NUMERICAL_POINT"),

    NUMERICAL_NAN("NUMERICAL_NAN"),

    NEW_FIELD_NAME("NEW_FIELD_NAME"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogAnomalyType> VALUE_MAP = EnumUtils.uniqueIndex(LogAnomalyType.class,
            LogAnomalyType::toString);

    private final String value;

    private LogAnomalyType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LogAnomalyType corresponding to the value
     */
    public static LogAnomalyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LogAnomalyType}s
     */
    public static Set<LogAnomalyType> knownValues() {
        Set<LogAnomalyType> knownValues = EnumSet.allOf(LogAnomalyType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
