/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter for insights that have any status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsAnyStatusFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListInsightsAnyStatusFilter.Builder, ListInsightsAnyStatusFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListInsightsAnyStatusFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<StartTimeRange> START_TIME_RANGE_FIELD = SdkField
            .<StartTimeRange> builder(MarshallingType.SDK_POJO).memberName("StartTimeRange")
            .getter(getter(ListInsightsAnyStatusFilter::startTimeRange)).setter(setter(Builder::startTimeRange))
            .constructor(StartTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            START_TIME_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final StartTimeRange startTimeRange;

    private ListInsightsAnyStatusFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimeRange = builder.startTimeRange;
    }

    /**
     * <p>
     * Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
     * @see InsightType
     */
    public final InsightType type() {
        return InsightType.fromValue(type);
    }

    /**
     * <p>
     * Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
     * @see InsightType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A time range used to specify when the behavior of the filtered insights started.
     * </p>
     * 
     * @return A time range used to specify when the behavior of the filtered insights started.
     */
    public final StartTimeRange startTimeRange() {
        return startTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsAnyStatusFilter)) {
            return false;
        }
        ListInsightsAnyStatusFilter other = (ListInsightsAnyStatusFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(startTimeRange(), other.startTimeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsAnyStatusFilter").add("Type", typeAsString())
                .add("StartTimeRange", startTimeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "StartTimeRange":
            return Optional.ofNullable(clazz.cast(startTimeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsAnyStatusFilter, T> g) {
        return obj -> g.apply((ListInsightsAnyStatusFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListInsightsAnyStatusFilter> {
        /**
         * <p>
         * Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
         * </p>
         * 
         * @param type
         *        Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder type(String type);

        /**
         * <p>
         * Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
         * </p>
         * 
         * @param type
         *        Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder type(InsightType type);

        /**
         * <p>
         * A time range used to specify when the behavior of the filtered insights started.
         * </p>
         * 
         * @param startTimeRange
         *        A time range used to specify when the behavior of the filtered insights started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeRange(StartTimeRange startTimeRange);

        /**
         * <p>
         * A time range used to specify when the behavior of the filtered insights started.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartTimeRange.Builder} avoiding the need
         * to create one manually via {@link StartTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #startTimeRange(StartTimeRange)}.
         * 
         * @param startTimeRange
         *        a consumer that will call methods on {@link StartTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeRange(StartTimeRange)
         */
        default Builder startTimeRange(Consumer<StartTimeRange.Builder> startTimeRange) {
            return startTimeRange(StartTimeRange.builder().applyMutation(startTimeRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private StartTimeRange startTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsAnyStatusFilter model) {
            type(model.type);
            startTimeRange(model.startTimeRange);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InsightType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final StartTimeRange.Builder getStartTimeRange() {
            return startTimeRange != null ? startTimeRange.toBuilder() : null;
        }

        public final void setStartTimeRange(StartTimeRange.BuilderImpl startTimeRange) {
            this.startTimeRange = startTimeRange != null ? startTimeRange.build() : null;
        }

        @Override
        public final Builder startTimeRange(StartTimeRange startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        @Override
        public ListInsightsAnyStatusFilter build() {
            return new ListInsightsAnyStatusFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
