/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters you can use to specify which events are returned when <code>ListEvents</code> is called.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListEventsFilters.Builder, ListEventsFilters> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightId").getter(getter(ListEventsFilters::insightId)).setter(setter(Builder::insightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()).build();

    private static final SdkField<EventTimeRange> EVENT_TIME_RANGE_FIELD = SdkField
            .<EventTimeRange> builder(MarshallingType.SDK_POJO).memberName("EventTimeRange")
            .getter(getter(ListEventsFilters::eventTimeRange)).setter(setter(Builder::eventTimeRange))
            .constructor(EventTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeRange").build()).build();

    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventClass").getter(getter(ListEventsFilters::eventClassAsString)).setter(setter(Builder::eventClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventClass").build()).build();

    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(ListEventsFilters::eventSource)).setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(ListEventsFilters::dataSourceAsString)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ListEventsFilters::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD,
            EVENT_TIME_RANGE_FIELD, EVENT_CLASS_FIELD, EVENT_SOURCE_FIELD, DATA_SOURCE_FIELD, RESOURCE_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String insightId;

    private final EventTimeRange eventTimeRange;

    private final String eventClass;

    private final String eventSource;

    private final String dataSource;

    private final ResourceCollection resourceCollection;

    private ListEventsFilters(BuilderImpl builder) {
        this.insightId = builder.insightId;
        this.eventTimeRange = builder.eventTimeRange;
        this.eventClass = builder.eventClass;
        this.eventSource = builder.eventSource;
        this.dataSource = builder.dataSource;
        this.resourceCollection = builder.resourceCollection;
    }

    /**
     * <p>
     * An ID of an insight that is related to the events you want to filter for.
     * </p>
     * 
     * @return An ID of an insight that is related to the events you want to filter for.
     */
    public final String insightId() {
        return insightId;
    }

    /**
     * <p>
     * A time range during which you want the filtered events to have occurred.
     * </p>
     * 
     * @return A time range during which you want the filtered events to have occurred.
     */
    public final EventTimeRange eventTimeRange() {
        return eventTimeRange;
    }

    /**
     * <p>
     * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema
     * change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link EventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The class of the events you want to filter for, such as an infrastructure change, a deployment, or a
     *         schema change.
     * @see EventClass
     */
    public final EventClass eventClass() {
        return EventClass.fromValue(eventClass);
    }

    /**
     * <p>
     * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema
     * change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link EventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The class of the events you want to filter for, such as an infrastructure change, a deployment, or a
     *         schema change.
     * @see EventClass
     */
    public final String eventClassAsString() {
        return eventClass;
    }

    /**
     * <p>
     * The Amazon Web Services source that emitted the events you want to filter for.
     * </p>
     * 
     * @return The Amazon Web Services source that emitted the events you want to filter for.
     */
    public final String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link EventDataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want
     *         returned.
     * @see EventDataSource
     */
    public final EventDataSource dataSource() {
        return EventDataSource.fromValue(dataSource);
    }

    /**
     * <p>
     * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link EventDataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want
     *         returned.
     * @see EventDataSource
     */
    public final String dataSourceAsString() {
        return dataSource;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventsFilters)) {
            return false;
        }
        ListEventsFilters other = (ListEventsFilters) obj;
        return Objects.equals(insightId(), other.insightId()) && Objects.equals(eventTimeRange(), other.eventTimeRange())
                && Objects.equals(eventClassAsString(), other.eventClassAsString())
                && Objects.equals(eventSource(), other.eventSource())
                && Objects.equals(dataSourceAsString(), other.dataSourceAsString())
                && Objects.equals(resourceCollection(), other.resourceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventsFilters").add("InsightId", insightId()).add("EventTimeRange", eventTimeRange())
                .add("EventClass", eventClassAsString()).add("EventSource", eventSource())
                .add("DataSource", dataSourceAsString()).add("ResourceCollection", resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightId":
            return Optional.ofNullable(clazz.cast(insightId()));
        case "EventTimeRange":
            return Optional.ofNullable(clazz.cast(eventTimeRange()));
        case "EventClass":
            return Optional.ofNullable(clazz.cast(eventClassAsString()));
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSource()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSourceAsString()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventsFilters, T> g) {
        return obj -> g.apply((ListEventsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListEventsFilters> {
        /**
         * <p>
         * An ID of an insight that is related to the events you want to filter for.
         * </p>
         * 
         * @param insightId
         *        An ID of an insight that is related to the events you want to filter for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightId(String insightId);

        /**
         * <p>
         * A time range during which you want the filtered events to have occurred.
         * </p>
         * 
         * @param eventTimeRange
         *        A time range during which you want the filtered events to have occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimeRange(EventTimeRange eventTimeRange);

        /**
         * <p>
         * A time range during which you want the filtered events to have occurred.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventTimeRange.Builder} avoiding the need
         * to create one manually via {@link EventTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTimeRange(EventTimeRange)}.
         * 
         * @param eventTimeRange
         *        a consumer that will call methods on {@link EventTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTimeRange(EventTimeRange)
         */
        default Builder eventTimeRange(Consumer<EventTimeRange.Builder> eventTimeRange) {
            return eventTimeRange(EventTimeRange.builder().applyMutation(eventTimeRange).build());
        }

        /**
         * <p>
         * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema
         * change.
         * </p>
         * 
         * @param eventClass
         *        The class of the events you want to filter for, such as an infrastructure change, a deployment, or a
         *        schema change.
         * @see EventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventClass
         */
        Builder eventClass(String eventClass);

        /**
         * <p>
         * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema
         * change.
         * </p>
         * 
         * @param eventClass
         *        The class of the events you want to filter for, such as an infrastructure change, a deployment, or a
         *        schema change.
         * @see EventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventClass
         */
        Builder eventClass(EventClass eventClass);

        /**
         * <p>
         * The Amazon Web Services source that emitted the events you want to filter for.
         * </p>
         * 
         * @param eventSource
         *        The Amazon Web Services source that emitted the events you want to filter for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
         * </p>
         * 
         * @param dataSource
         *        The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want
         *        returned.
         * @see EventDataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataSource
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
         * </p>
         * 
         * @param dataSource
         *        The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want
         *        returned.
         * @see EventDataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataSource
         */
        Builder dataSource(EventDataSource dataSource);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String insightId;

        private EventTimeRange eventTimeRange;

        private String eventClass;

        private String eventSource;

        private String dataSource;

        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventsFilters model) {
            insightId(model.insightId);
            eventTimeRange(model.eventTimeRange);
            eventClass(model.eventClass);
            eventSource(model.eventSource);
            dataSource(model.dataSource);
            resourceCollection(model.resourceCollection);
        }

        public final String getInsightId() {
            return insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final EventTimeRange.Builder getEventTimeRange() {
            return eventTimeRange != null ? eventTimeRange.toBuilder() : null;
        }

        public final void setEventTimeRange(EventTimeRange.BuilderImpl eventTimeRange) {
            this.eventTimeRange = eventTimeRange != null ? eventTimeRange.build() : null;
        }

        @Override
        public final Builder eventTimeRange(EventTimeRange eventTimeRange) {
            this.eventTimeRange = eventTimeRange;
            return this;
        }

        public final String getEventClass() {
            return eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(EventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(EventDataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        @Override
        public ListEventsFilters build() {
            return new ListEventsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
