/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalousLogGroupsResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<ListAnomalousLogGroupsResponse.Builder, ListAnomalousLogGroupsResponse> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightId").getter(getter(ListAnomalousLogGroupsResponse::insightId)).setter(setter(Builder::insightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()).build();

    private static final SdkField<List<AnomalousLogGroup>> ANOMALOUS_LOG_GROUPS_FIELD = SdkField
            .<List<AnomalousLogGroup>> builder(MarshallingType.LIST)
            .memberName("AnomalousLogGroups")
            .getter(getter(ListAnomalousLogGroupsResponse::anomalousLogGroups))
            .setter(setter(Builder::anomalousLogGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalousLogGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnomalousLogGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnomalousLogGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalousLogGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD,
            ANOMALOUS_LOG_GROUPS_FIELD, NEXT_TOKEN_FIELD));

    private final String insightId;

    private final List<AnomalousLogGroup> anomalousLogGroups;

    private final String nextToken;

    private ListAnomalousLogGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
        this.anomalousLogGroups = builder.anomalousLogGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the insight containing the log groups.
     * </p>
     * 
     * @return The ID of the insight containing the log groups.
     */
    public final String insightId() {
        return insightId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnomalousLogGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnomalousLogGroups() {
        return anomalousLogGroups != null && !(anomalousLogGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon CloudWatch log groups that are related to an insight.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnomalousLogGroups} method.
     * </p>
     * 
     * @return The list of Amazon CloudWatch log groups that are related to an insight.
     */
    public final List<AnomalousLogGroup> anomalousLogGroups() {
        return anomalousLogGroups;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalousLogGroups() ? anomalousLogGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalousLogGroupsResponse)) {
            return false;
        }
        ListAnomalousLogGroupsResponse other = (ListAnomalousLogGroupsResponse) obj;
        return Objects.equals(insightId(), other.insightId()) && hasAnomalousLogGroups() == other.hasAnomalousLogGroups()
                && Objects.equals(anomalousLogGroups(), other.anomalousLogGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalousLogGroupsResponse").add("InsightId", insightId())
                .add("AnomalousLogGroups", hasAnomalousLogGroups() ? anomalousLogGroups() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightId":
            return Optional.ofNullable(clazz.cast(insightId()));
        case "AnomalousLogGroups":
            return Optional.ofNullable(clazz.cast(anomalousLogGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalousLogGroupsResponse, T> g) {
        return obj -> g.apply((ListAnomalousLogGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalousLogGroupsResponse> {
        /**
         * <p>
         * The ID of the insight containing the log groups.
         * </p>
         * 
         * @param insightId
         *        The ID of the insight containing the log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightId(String insightId);

        /**
         * <p>
         * The list of Amazon CloudWatch log groups that are related to an insight.
         * </p>
         * 
         * @param anomalousLogGroups
         *        The list of Amazon CloudWatch log groups that are related to an insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalousLogGroups(Collection<AnomalousLogGroup> anomalousLogGroups);

        /**
         * <p>
         * The list of Amazon CloudWatch log groups that are related to an insight.
         * </p>
         * 
         * @param anomalousLogGroups
         *        The list of Amazon CloudWatch log groups that are related to an insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalousLogGroups(AnomalousLogGroup... anomalousLogGroups);

        /**
         * <p>
         * The list of Amazon CloudWatch log groups that are related to an insight.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #anomalousLogGroups(List<AnomalousLogGroup>)}.
         * 
         * @param anomalousLogGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalousLogGroups(java.util.Collection<AnomalousLogGroup>)
         */
        Builder anomalousLogGroups(Consumer<AnomalousLogGroup.Builder>... anomalousLogGroups);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private String insightId;

        private List<AnomalousLogGroup> anomalousLogGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalousLogGroupsResponse model) {
            super(model);
            insightId(model.insightId);
            anomalousLogGroups(model.anomalousLogGroups);
            nextToken(model.nextToken);
        }

        public final String getInsightId() {
            return insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final List<AnomalousLogGroup.Builder> getAnomalousLogGroups() {
            List<AnomalousLogGroup.Builder> result = AnomalousLogGroupsCopier.copyToBuilder(this.anomalousLogGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalousLogGroups(Collection<AnomalousLogGroup.BuilderImpl> anomalousLogGroups) {
            this.anomalousLogGroups = AnomalousLogGroupsCopier.copyFromBuilder(anomalousLogGroups);
        }

        @Override
        public final Builder anomalousLogGroups(Collection<AnomalousLogGroup> anomalousLogGroups) {
            this.anomalousLogGroups = AnomalousLogGroupsCopier.copy(anomalousLogGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalousLogGroups(AnomalousLogGroup... anomalousLogGroups) {
            anomalousLogGroups(Arrays.asList(anomalousLogGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalousLogGroups(Consumer<AnomalousLogGroup.Builder>... anomalousLogGroups) {
            anomalousLogGroups(Stream.of(anomalousLogGroups).map(c -> AnomalousLogGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalousLogGroupsResponse build() {
            return new ListAnomalousLogGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
