/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruServiceClientConfiguration;
import software.amazon.awssdk.services.devopsguru.model.AccessDeniedException;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.ConflictException;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruException;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.InternalServerException;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListEventsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListEventsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.ResourceNotFoundException;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.ThrottlingException;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.model.ValidationException;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable;
import software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable;
import software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable;
import software.amazon.awssdk.services.devopsguru.transform.AddNotificationChannelRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DeleteInsightRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeAccountHealthRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeAccountOverviewRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeAnomalyRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeEventSourcesConfigRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeFeedbackRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeInsightRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeOrganizationHealthRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeOrganizationOverviewRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeOrganizationResourceCollectionHealthRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeResourceCollectionHealthRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.DescribeServiceIntegrationRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.GetCostEstimationRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.GetResourceCollectionRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListAnomaliesForInsightRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListAnomalousLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListEventsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListInsightsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListMonitoredResourcesRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListNotificationChannelsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListOrganizationInsightsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.RemoveNotificationChannelRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.SearchInsightsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.SearchOrganizationInsightsRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.StartCostEstimationRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.UpdateEventSourcesConfigRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.UpdateResourceCollectionRequestMarshaller;
import software.amazon.awssdk.services.devopsguru.transform.UpdateServiceIntegrationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDevOpsGuruClient
implements DevOpsGuruClient {
    private static final Logger log = Logger.loggerFor(DefaultDevOpsGuruClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final DevOpsGuruServiceClientConfiguration serviceClientConfiguration;

    protected DefaultDevOpsGuruClient(DevOpsGuruServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddNotificationChannelResponse addNotificationChannel(AddNotificationChannelRequest addNotificationChannelRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddNotificationChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, addNotificationChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddNotificationChannel");
            AddNotificationChannelResponse addNotificationChannelResponse = (AddNotificationChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddNotificationChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addNotificationChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddNotificationChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addNotificationChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$addNotificationChannel$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInsightResponse deleteInsight(DeleteInsightRequest deleteInsightRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, deleteInsightRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInsight");
            DeleteInsightResponse deleteInsightResponse = (DeleteInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInsightRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInsightResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$deleteInsight$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountHealthResponse describeAccountHealth(DescribeAccountHealthRequest describeAccountHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountHealthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeAccountHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountHealth");
            DescribeAccountHealthResponse describeAccountHealthResponse = (DescribeAccountHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeAccountHealth$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountOverviewResponse describeAccountOverview(DescribeAccountOverviewRequest describeAccountOverviewRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountOverviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeAccountOverviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountOverview");
            DescribeAccountOverviewResponse describeAccountOverviewResponse = (DescribeAccountOverviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountOverview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountOverviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountOverviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountOverviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeAccountOverview$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnomalyResponse describeAnomaly(DescribeAnomalyRequest describeAnomalyRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAnomalyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeAnomalyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnomaly");
            DescribeAnomalyResponse describeAnomalyResponse = (DescribeAnomalyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomaly").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnomalyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAnomalyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAnomalyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeAnomaly$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSourcesConfigResponse describeEventSourcesConfig(DescribeEventSourcesConfigRequest describeEventSourcesConfigRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSourcesConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeEventSourcesConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSourcesConfig");
            DescribeEventSourcesConfigResponse describeEventSourcesConfigResponse = (DescribeEventSourcesConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSourcesConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSourcesConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSourcesConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventSourcesConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeEventSourcesConfig$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFeedbackResponse describeFeedback(DescribeFeedbackRequest describeFeedbackRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFeedback");
            DescribeFeedbackResponse describeFeedbackResponse = (DescribeFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeFeedback$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInsightResponse describeInsight(DescribeInsightRequest describeInsightRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeInsightRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInsight");
            DescribeInsightResponse describeInsightResponse = (DescribeInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInsightRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInsightResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeInsight$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationHealthResponse describeOrganizationHealth(DescribeOrganizationHealthRequest describeOrganizationHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationHealthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeOrganizationHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationHealth");
            DescribeOrganizationHealthResponse describeOrganizationHealthResponse = (DescribeOrganizationHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeOrganizationHealth$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationOverviewResponse describeOrganizationOverview(DescribeOrganizationOverviewRequest describeOrganizationOverviewRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationOverviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeOrganizationOverviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationOverview");
            DescribeOrganizationOverviewResponse describeOrganizationOverviewResponse = (DescribeOrganizationOverviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationOverview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationOverviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationOverviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationOverviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeOrganizationOverview$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationResourceCollectionHealthResponse describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationResourceCollectionHealthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeOrganizationResourceCollectionHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationResourceCollectionHealth");
            DescribeOrganizationResourceCollectionHealthResponse describeOrganizationResourceCollectionHealthResponse = (DescribeOrganizationResourceCollectionHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationResourceCollectionHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationResourceCollectionHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationResourceCollectionHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationResourceCollectionHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeOrganizationResourceCollectionHealth$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeOrganizationResourceCollectionHealthIterable describeOrganizationResourceCollectionHealthPaginator(DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new DescribeOrganizationResourceCollectionHealthIterable(this, this.applyPaginatorUserAgent(describeOrganizationResourceCollectionHealthRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceCollectionHealthResponse describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceCollectionHealthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeResourceCollectionHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourceCollectionHealth");
            DescribeResourceCollectionHealthResponse describeResourceCollectionHealthResponse = (DescribeResourceCollectionHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourceCollectionHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourceCollectionHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourceCollectionHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourceCollectionHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeResourceCollectionHealth$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeResourceCollectionHealthIterable describeResourceCollectionHealthPaginator(DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new DescribeResourceCollectionHealthIterable(this, this.applyPaginatorUserAgent(describeResourceCollectionHealthRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceIntegrationResponse describeServiceIntegration(DescribeServiceIntegrationRequest describeServiceIntegrationRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceIntegrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, describeServiceIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceIntegration");
            DescribeServiceIntegrationResponse describeServiceIntegrationResponse = (DescribeServiceIntegrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceIntegration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServiceIntegrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceIntegrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$describeServiceIntegration$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostEstimationResponse getCostEstimation(GetCostEstimationRequest getCostEstimationRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostEstimationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, getCostEstimationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostEstimation");
            GetCostEstimationResponse getCostEstimationResponse = (GetCostEstimationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostEstimation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostEstimationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostEstimationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostEstimationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$getCostEstimation$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetCostEstimationIterable getCostEstimationPaginator(GetCostEstimationRequest getCostEstimationRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new GetCostEstimationIterable(this, this.applyPaginatorUserAgent(getCostEstimationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceCollectionResponse getResourceCollection(GetResourceCollectionRequest getResourceCollectionRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, getResourceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceCollection");
            GetResourceCollectionResponse getResourceCollectionResponse = (GetResourceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$getResourceCollection$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourceCollectionIterable getResourceCollectionPaginator(GetResourceCollectionRequest getResourceCollectionRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new GetResourceCollectionIterable(this, this.applyPaginatorUserAgent(getResourceCollectionRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomaliesForInsightResponse listAnomaliesForInsight(ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomaliesForInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listAnomaliesForInsightRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomaliesForInsight");
            ListAnomaliesForInsightResponse listAnomaliesForInsightResponse = (ListAnomaliesForInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomaliesForInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomaliesForInsightRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomaliesForInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomaliesForInsightResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listAnomaliesForInsight$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomaliesForInsightIterable listAnomaliesForInsightPaginator(ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListAnomaliesForInsightIterable(this, this.applyPaginatorUserAgent(listAnomaliesForInsightRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomalousLogGroupsResponse listAnomalousLogGroups(ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomalousLogGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listAnomalousLogGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalousLogGroups");
            ListAnomalousLogGroupsResponse listAnomalousLogGroupsResponse = (ListAnomalousLogGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalousLogGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomalousLogGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomalousLogGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomalousLogGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listAnomalousLogGroups$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomalousLogGroupsIterable listAnomalousLogGroupsPaginator(ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListAnomalousLogGroupsIterable(this, this.applyPaginatorUserAgent(listAnomalousLogGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventsResponse listEvents(ListEventsRequest listEventsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEvents");
            ListEventsResponse listEventsResponse = (ListEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listEvents$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEventsIterable listEventsPaginator(ListEventsRequest listEventsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListEventsIterable(this, this.applyPaginatorUserAgent(listEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInsightsResponse listInsights(ListInsightsRequest listInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInsights");
            ListInsightsResponse listInsightsResponse = (ListInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listInsights$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListInsightsIterable listInsightsPaginator(ListInsightsRequest listInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListInsightsIterable(this, this.applyPaginatorUserAgent(listInsightsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMonitoredResourcesResponse listMonitoredResources(ListMonitoredResourcesRequest listMonitoredResourcesRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMonitoredResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listMonitoredResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMonitoredResources");
            ListMonitoredResourcesResponse listMonitoredResourcesResponse = (ListMonitoredResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMonitoredResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMonitoredResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMonitoredResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMonitoredResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listMonitoredResources$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMonitoredResourcesIterable listMonitoredResourcesPaginator(ListMonitoredResourcesRequest listMonitoredResourcesRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListMonitoredResourcesIterable(this, this.applyPaginatorUserAgent(listMonitoredResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotificationChannelsResponse listNotificationChannels(ListNotificationChannelsRequest listNotificationChannelsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotificationChannelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listNotificationChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNotificationChannels");
            ListNotificationChannelsResponse listNotificationChannelsResponse = (ListNotificationChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotificationChannels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotificationChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNotificationChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNotificationChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listNotificationChannels$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNotificationChannelsIterable listNotificationChannelsPaginator(ListNotificationChannelsRequest listNotificationChannelsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListNotificationChannelsIterable(this, this.applyPaginatorUserAgent(listNotificationChannelsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationInsightsResponse listOrganizationInsights(ListOrganizationInsightsRequest listOrganizationInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listOrganizationInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationInsights");
            ListOrganizationInsightsResponse listOrganizationInsightsResponse = (ListOrganizationInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listOrganizationInsights$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListOrganizationInsightsIterable listOrganizationInsightsPaginator(ListOrganizationInsightsRequest listOrganizationInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListOrganizationInsightsIterable(this, this.applyPaginatorUserAgent(listOrganizationInsightsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, listRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendations");
            ListRecommendationsResponse listRecommendationsResponse = (ListRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$listRecommendations$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListRecommendationsIterable(this, this.applyPaginatorUserAgent(listRecommendationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, putFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutFeedback");
            PutFeedbackResponse putFeedbackResponse = (PutFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$putFeedback$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveNotificationChannelResponse removeNotificationChannel(RemoveNotificationChannelRequest removeNotificationChannelRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveNotificationChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, removeNotificationChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveNotificationChannel");
            RemoveNotificationChannelResponse removeNotificationChannelResponse = (RemoveNotificationChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveNotificationChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeNotificationChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveNotificationChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeNotificationChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$removeNotificationChannel$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchInsightsResponse searchInsights(SearchInsightsRequest searchInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, searchInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchInsights");
            SearchInsightsResponse searchInsightsResponse = (SearchInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$searchInsights$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchInsightsIterable searchInsightsPaginator(SearchInsightsRequest searchInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new SearchInsightsIterable(this, this.applyPaginatorUserAgent(searchInsightsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchOrganizationInsightsResponse searchOrganizationInsights(SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchOrganizationInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, searchOrganizationInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchOrganizationInsights");
            SearchOrganizationInsightsResponse searchOrganizationInsightsResponse = (SearchOrganizationInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchOrganizationInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchOrganizationInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchOrganizationInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchOrganizationInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$searchOrganizationInsights$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchOrganizationInsightsIterable searchOrganizationInsightsPaginator(SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new SearchOrganizationInsightsIterable(this, this.applyPaginatorUserAgent(searchOrganizationInsightsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCostEstimationResponse startCostEstimation(StartCostEstimationRequest startCostEstimationRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCostEstimationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, startCostEstimationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCostEstimation");
            StartCostEstimationResponse startCostEstimationResponse = (StartCostEstimationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCostEstimation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCostEstimationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCostEstimationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCostEstimationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$startCostEstimation$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventSourcesConfigResponse updateEventSourcesConfig(UpdateEventSourcesConfigRequest updateEventSourcesConfigRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEventSourcesConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, updateEventSourcesConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEventSourcesConfig");
            UpdateEventSourcesConfigResponse updateEventSourcesConfigResponse = (UpdateEventSourcesConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEventSourcesConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEventSourcesConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEventSourcesConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEventSourcesConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$updateEventSourcesConfig$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceCollectionResponse updateResourceCollection(UpdateResourceCollectionRequest updateResourceCollectionRequest) throws AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, updateResourceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceCollection");
            UpdateResourceCollectionResponse updateResourceCollectionResponse = (UpdateResourceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$updateResourceCollection$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceIntegrationResponse updateServiceIntegration(UpdateServiceIntegrationRequest updateServiceIntegrationRequest) throws AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceIntegrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDevOpsGuruClient.resolveMetricPublishers(this.clientConfiguration, updateServiceIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DevOps Guru");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceIntegration");
            UpdateServiceIntegrationResponse updateServiceIntegrationResponse = (UpdateServiceIntegrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceIntegration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceIntegrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceIntegrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceIntegrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDevOpsGuruClient.lambda$updateServiceIntegration$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends DevOpsGuruRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.54").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DevOpsGuruRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "devops-guru";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DevOpsGuruException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final DevOpsGuruServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceIntegration$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResourceCollection$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEventSourcesConfig$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCostEstimation$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchOrganizationInsights$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchInsights$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeNotificationChannel$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putFeedback$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendations$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationInsights$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNotificationChannels$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMonitoredResources$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInsights$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEvents$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomalousLogGroups$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomaliesForInsight$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceCollection$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostEstimation$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceIntegration$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourceCollectionHealth$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationResourceCollectionHealth$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationOverview$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationHealth$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInsight$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFeedback$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventSourcesConfig$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnomaly$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountOverview$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountHealth$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInsight$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addNotificationChannel$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

