/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse;

public class ListAnomalousLogGroupsPublisher
implements SdkPublisher<ListAnomalousLogGroupsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListAnomalousLogGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnomalousLogGroupsPublisher(DevOpsGuruAsyncClient client, ListAnomalousLogGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnomalousLogGroupsPublisher(DevOpsGuruAsyncClient client, ListAnomalousLogGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnomalousLogGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnomalousLogGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalousLogGroup> anomalousLogGroups() {
        Function<ListAnomalousLogGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalousLogGroups() != null) {
                return response.anomalousLogGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnomalousLogGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnomalousLogGroupsResponseFetcher
    implements AsyncPageFetcher<ListAnomalousLogGroupsResponse> {
        private ListAnomalousLogGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalousLogGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnomalousLogGroupsResponse> nextPage(ListAnomalousLogGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalousLogGroupsPublisher.this.client.listAnomalousLogGroups(ListAnomalousLogGroupsPublisher.this.firstRequest);
            }
            return ListAnomalousLogGroupsPublisher.this.client.listAnomalousLogGroups((ListAnomalousLogGroupsRequest)((Object)ListAnomalousLogGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

