/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary;

public class ListOrganizationInsightsIterable
implements SdkIterable<ListOrganizationInsightsResponse> {
    private final DevOpsGuruClient client;
    private final ListOrganizationInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationInsightsIterable(DevOpsGuruClient client, ListOrganizationInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOrganizationInsightsResponseFetcher();
    }

    public Iterator<ListOrganizationInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProactiveOrganizationInsightSummary> proactiveInsights() {
        Function<ListOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ReactiveOrganizationInsightSummary> reactiveInsights() {
        Function<ListOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationInsightsResponseFetcher
    implements SyncPageFetcher<ListOrganizationInsightsResponse> {
        private ListOrganizationInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationInsightsResponse nextPage(ListOrganizationInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationInsightsIterable.this.client.listOrganizationInsights(ListOrganizationInsightsIterable.this.firstRequest);
            }
            return ListOrganizationInsightsIterable.this.client.listOrganizationInsights((ListOrganizationInsightsRequest)((Object)ListOrganizationInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

