/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightsCopier;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInsightsResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListInsightsResponse> {
    private static final SdkField<List<ProactiveInsightSummary>> PROACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProactiveInsights").getter(ListInsightsResponse.getter(ListInsightsResponse::proactiveInsights)).setter(ListInsightsResponse.setter(Builder::proactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProactiveInsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReactiveInsightSummary>> REACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReactiveInsights").getter(ListInsightsResponse.getter(ListInsightsResponse::reactiveInsights)).setter(ListInsightsResponse.setter(Builder::reactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReactiveInsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInsightsResponse.getter(ListInsightsResponse::nextToken)).setter(ListInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHTS_FIELD, REACTIVE_INSIGHTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProactiveInsightSummary> proactiveInsights;
    private final List<ReactiveInsightSummary> reactiveInsights;
    private final String nextToken;

    private ListInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsights = builder.proactiveInsights;
        this.reactiveInsights = builder.reactiveInsights;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProactiveInsights() {
        return this.proactiveInsights != null && !(this.proactiveInsights instanceof SdkAutoConstructList);
    }

    public final List<ProactiveInsightSummary> proactiveInsights() {
        return this.proactiveInsights;
    }

    public final boolean hasReactiveInsights() {
        return this.reactiveInsights != null && !(this.reactiveInsights instanceof SdkAutoConstructList);
    }

    public final List<ReactiveInsightSummary> reactiveInsights() {
        return this.reactiveInsights;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProactiveInsights() ? this.proactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactiveInsights() ? this.reactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsResponse)) {
            return false;
        }
        ListInsightsResponse other = (ListInsightsResponse)((Object)obj);
        return this.hasProactiveInsights() == other.hasProactiveInsights() && Objects.equals(this.proactiveInsights(), other.proactiveInsights()) && this.hasReactiveInsights() == other.hasReactiveInsights() && Objects.equals(this.reactiveInsights(), other.reactiveInsights()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInsightsResponse").add("ProactiveInsights", this.hasProactiveInsights() ? this.proactiveInsights() : null).add("ReactiveInsights", this.hasReactiveInsights() ? this.reactiveInsights() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.proactiveInsights()));
            }
            case "ReactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.reactiveInsights()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsResponse, T> g) {
        return obj -> g.apply((ListInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<ProactiveInsightSummary> proactiveInsights = DefaultSdkAutoConstructList.getInstance();
        private List<ReactiveInsightSummary> reactiveInsights = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsResponse model) {
            super(model);
            this.proactiveInsights(model.proactiveInsights);
            this.reactiveInsights(model.reactiveInsights);
            this.nextToken(model.nextToken);
        }

        public final List<ProactiveInsightSummary.Builder> getProactiveInsights() {
            List<ProactiveInsightSummary.Builder> result = ProactiveInsightsCopier.copyToBuilder(this.proactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProactiveInsights(Collection<ProactiveInsightSummary.BuilderImpl> proactiveInsights) {
            this.proactiveInsights = ProactiveInsightsCopier.copyFromBuilder(proactiveInsights);
        }

        @Override
        @Transient
        public final Builder proactiveInsights(Collection<ProactiveInsightSummary> proactiveInsights) {
            this.proactiveInsights = ProactiveInsightsCopier.copy(proactiveInsights);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder proactiveInsights(ProactiveInsightSummary ... proactiveInsights) {
            this.proactiveInsights(Arrays.asList(proactiveInsights));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder proactiveInsights(Consumer<ProactiveInsightSummary.Builder> ... proactiveInsights) {
            this.proactiveInsights(Stream.of(proactiveInsights).map(c -> (ProactiveInsightSummary)((ProactiveInsightSummary.Builder)ProactiveInsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReactiveInsightSummary.Builder> getReactiveInsights() {
            List<ReactiveInsightSummary.Builder> result = ReactiveInsightsCopier.copyToBuilder(this.reactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactiveInsights(Collection<ReactiveInsightSummary.BuilderImpl> reactiveInsights) {
            this.reactiveInsights = ReactiveInsightsCopier.copyFromBuilder(reactiveInsights);
        }

        @Override
        @Transient
        public final Builder reactiveInsights(Collection<ReactiveInsightSummary> reactiveInsights) {
            this.reactiveInsights = ReactiveInsightsCopier.copy(reactiveInsights);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reactiveInsights(ReactiveInsightSummary ... reactiveInsights) {
            this.reactiveInsights(Arrays.asList(reactiveInsights));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reactiveInsights(Consumer<ReactiveInsightSummary.Builder> ... reactiveInsights) {
            this.reactiveInsights(Stream.of(reactiveInsights).map(c -> (ReactiveInsightSummary)((ReactiveInsightSummary.Builder)ReactiveInsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInsightsResponse build() {
            return new ListInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInsightsResponse> {
        public Builder proactiveInsights(Collection<ProactiveInsightSummary> var1);

        public Builder proactiveInsights(ProactiveInsightSummary ... var1);

        public Builder proactiveInsights(Consumer<ProactiveInsightSummary.Builder> ... var1);

        public Builder reactiveInsights(Collection<ReactiveInsightSummary> var1);

        public Builder reactiveInsights(ReactiveInsightSummary ... var1);

        public Builder reactiveInsights(Consumer<ReactiveInsightSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

