/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;

public class ListInsightsIterable
implements SdkIterable<ListInsightsResponse> {
    private final DevOpsGuruClient client;
    private final ListInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInsightsIterable(DevOpsGuruClient client, ListInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInsightsResponseFetcher();
    }

    public Iterator<ListInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProactiveInsightSummary> proactiveInsights() {
        Function<ListInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ReactiveInsightSummary> reactiveInsights() {
        Function<ListInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInsightsResponseFetcher
    implements SyncPageFetcher<ListInsightsResponse> {
        private ListInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInsightsResponse nextPage(ListInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsIterable.this.client.listInsights(ListInsightsIterable.this.firstRequest);
            }
            return ListInsightsIterable.this.client.listInsights((ListInsightsRequest)((Object)ListInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

