/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceIntegrationRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<UpdateServiceIntegrationRequest.Builder, UpdateServiceIntegrationRequest> {
    private static final SdkField<UpdateServiceIntegrationConfig> SERVICE_INTEGRATION_FIELD = SdkField
            .<UpdateServiceIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("ServiceIntegration")
            .getter(getter(UpdateServiceIntegrationRequest::serviceIntegration)).setter(setter(Builder::serviceIntegration))
            .constructor(UpdateServiceIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_INTEGRATION_FIELD));

    private final UpdateServiceIntegrationConfig serviceIntegration;

    private UpdateServiceIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIntegration = builder.serviceIntegration;
    }

    /**
     * <p>
     * An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and
     * whether you want to update it to enabled or disabled.
     * </p>
     * 
     * @return An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update,
     *         and whether you want to update it to enabled or disabled.
     */
    public final UpdateServiceIntegrationConfig serviceIntegration() {
        return serviceIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceIntegration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceIntegrationRequest)) {
            return false;
        }
        UpdateServiceIntegrationRequest other = (UpdateServiceIntegrationRequest) obj;
        return Objects.equals(serviceIntegration(), other.serviceIntegration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceIntegrationRequest").add("ServiceIntegration", serviceIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceIntegration":
            return Optional.ofNullable(clazz.cast(serviceIntegration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceIntegrationRequest, T> g) {
        return obj -> g.apply((UpdateServiceIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceIntegrationRequest> {
        /**
         * <p>
         * An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and
         * whether you want to update it to enabled or disabled.
         * </p>
         * 
         * @param serviceIntegration
         *        An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to
         *        update, and whether you want to update it to enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIntegration(UpdateServiceIntegrationConfig serviceIntegration);

        /**
         * <p>
         * An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and
         * whether you want to update it to enabled or disabled.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateServiceIntegrationConfig.Builder} avoiding
         * the need to create one manually via {@link UpdateServiceIntegrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateServiceIntegrationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceIntegration(UpdateServiceIntegrationConfig)}.
         * 
         * @param serviceIntegration
         *        a consumer that will call methods on {@link UpdateServiceIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIntegration(UpdateServiceIntegrationConfig)
         */
        default Builder serviceIntegration(Consumer<UpdateServiceIntegrationConfig.Builder> serviceIntegration) {
            return serviceIntegration(UpdateServiceIntegrationConfig.builder().applyMutation(serviceIntegration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private UpdateServiceIntegrationConfig serviceIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceIntegrationRequest model) {
            super(model);
            serviceIntegration(model.serviceIntegration);
        }

        public final UpdateServiceIntegrationConfig.Builder getServiceIntegration() {
            return serviceIntegration != null ? serviceIntegration.toBuilder() : null;
        }

        @Override
        public final Builder serviceIntegration(UpdateServiceIntegrationConfig serviceIntegration) {
            this.serviceIntegration = serviceIntegration;
            return this;
        }

        public final void setServiceIntegration(UpdateServiceIntegrationConfig.BuilderImpl serviceIntegration) {
            this.serviceIntegration = serviceIntegration != null ? serviceIntegration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceIntegrationRequest build() {
            return new UpdateServiceIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
