/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information used to update a collection of AWS resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceCollectionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateResourceCollectionFilter.Builder, UpdateResourceCollectionFilter> {
    private static final SdkField<UpdateCloudFormationCollectionFilter> CLOUD_FORMATION_FIELD = SdkField
            .<UpdateCloudFormationCollectionFilter> builder(MarshallingType.SDK_POJO).memberName("CloudFormation")
            .getter(getter(UpdateResourceCollectionFilter::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(UpdateCloudFormationCollectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateCloudFormationCollectionFilter cloudFormation;

    private UpdateResourceCollectionFilter(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
    }

    /**
     * <p>
     * An collection of AWS CloudFormation stacks.
     * </p>
     * 
     * @return An collection of AWS CloudFormation stacks.
     */
    public final UpdateCloudFormationCollectionFilter cloudFormation() {
        return cloudFormation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceCollectionFilter)) {
            return false;
        }
        UpdateResourceCollectionFilter other = (UpdateResourceCollectionFilter) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceCollectionFilter").add("CloudFormation", cloudFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceCollectionFilter, T> g) {
        return obj -> g.apply((UpdateResourceCollectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateResourceCollectionFilter> {
        /**
         * <p>
         * An collection of AWS CloudFormation stacks.
         * </p>
         * 
         * @param cloudFormation
         *        An collection of AWS CloudFormation stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(UpdateCloudFormationCollectionFilter cloudFormation);

        /**
         * <p>
         * An collection of AWS CloudFormation stacks.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateCloudFormationCollectionFilter.Builder}
         * avoiding the need to create one manually via {@link UpdateCloudFormationCollectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateCloudFormationCollectionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudFormation(UpdateCloudFormationCollectionFilter)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link UpdateCloudFormationCollectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(UpdateCloudFormationCollectionFilter)
         */
        default Builder cloudFormation(Consumer<UpdateCloudFormationCollectionFilter.Builder> cloudFormation) {
            return cloudFormation(UpdateCloudFormationCollectionFilter.builder().applyMutation(cloudFormation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateCloudFormationCollectionFilter cloudFormation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceCollectionFilter model) {
            cloudFormation(model.cloudFormation);
        }

        public final UpdateCloudFormationCollectionFilter.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        @Override
        public final Builder cloudFormation(UpdateCloudFormationCollectionFilter cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final void setCloudFormation(UpdateCloudFormationCollectionFilter.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public UpdateResourceCollectionFilter build() {
            return new UpdateResourceCollectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
