/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more severity values and one or more status values that are used to search for insights.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchInsightsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchInsightsFilters.Builder, SearchInsightsFilters> {
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Severities")
            .getter(getter(SearchInsightsFilters::severitiesAsStrings))
            .setter(setter(Builder::severitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statuses")
            .getter(getter(SearchInsightsFilters::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(SearchInsightsFilters::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITIES_FIELD,
            STATUSES_FIELD, RESOURCE_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> severities;

    private final List<String> statuses;

    private final ResourceCollection resourceCollection;

    private SearchInsightsFilters(BuilderImpl builder) {
        this.severities = builder.severities;
        this.statuses = builder.statuses;
        this.resourceCollection = builder.resourceCollection;
    }

    /**
     * <p>
     * An array of severity values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of severity values used to search for insights.
     */
    public final List<InsightSeverity> severities() {
        return InsightSeveritiesCopier.copyStringToEnum(severities);
    }

    /**
     * Returns true if the Severities property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSeverities() {
        return severities != null && !(severities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of severity values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of severity values used to search for insights.
     */
    public final List<String> severitiesAsStrings() {
        return severities;
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     */
    public final List<InsightStatus> statuses() {
        return InsightStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * Returns true if the Statuses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of status values used to search for insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of status values used to search for insights.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverities() ? severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInsightsFilters)) {
            return false;
        }
        SearchInsightsFilters other = (SearchInsightsFilters) obj;
        return hasSeverities() == other.hasSeverities() && Objects.equals(severitiesAsStrings(), other.severitiesAsStrings())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && Objects.equals(resourceCollection(), other.resourceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchInsightsFilters").add("Severities", hasSeverities() ? severitiesAsStrings() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).add("ResourceCollection", resourceCollection())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Severities":
            return Optional.ofNullable(clazz.cast(severitiesAsStrings()));
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchInsightsFilters, T> g) {
        return obj -> g.apply((SearchInsightsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchInsightsFilters> {
        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(Collection<String> severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(String... severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(Collection<InsightSeverity> severities);

        /**
         * <p>
         * An array of severity values used to search for insights.
         * </p>
         * 
         * @param severities
         *        An array of severity values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(InsightSeverity... severities);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<InsightStatus> statuses);

        /**
         * <p>
         * An array of status values used to search for insights.
         * </p>
         * 
         * @param statuses
         *        An array of status values used to search for insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(InsightStatus... statuses);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceCollection.Builder} avoiding the need to
         * create one manually via {@link ResourceCollection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInsightsFilters model) {
            severitiesWithStrings(model.severities);
            statusesWithStrings(model.statuses);
            resourceCollection(model.resourceCollection);
        }

        public final Collection<String> getSeverities() {
            if (severities instanceof SdkAutoConstructList) {
                return null;
            }
            return severities;
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String... severities) {
            severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = InsightSeveritiesCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity... severities) {
            severities(Arrays.asList(severities));
            return this;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatus> statuses) {
            this.statuses = InsightStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public SearchInsightsFilters build() {
            return new SearchInsightsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
