/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array of <code>RecommendationRelatedCloudWatchMetricsSourceDetail</code> objects that contain the name
 * and namespace of an Amazon CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationRelatedAnomalySourceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationRelatedAnomalySourceDetail.Builder, RecommendationRelatedAnomalySourceDetail> {
    private static final SdkField<List<RecommendationRelatedCloudWatchMetricsSourceDetail>> CLOUD_WATCH_METRICS_FIELD = SdkField
            .<List<RecommendationRelatedCloudWatchMetricsSourceDetail>> builder(MarshallingType.LIST)
            .memberName("CloudWatchMetrics")
            .getter(getter(RecommendationRelatedAnomalySourceDetail::cloudWatchMetrics))
            .setter(setter(Builder::cloudWatchMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedCloudWatchMetricsSourceDetail> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedCloudWatchMetricsSourceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RecommendationRelatedCloudWatchMetricsSourceDetail> cloudWatchMetrics;

    private RecommendationRelatedAnomalySourceDetail(BuilderImpl builder) {
        this.cloudWatchMetrics = builder.cloudWatchMetrics;
    }

    /**
     * Returns true if the CloudWatchMetrics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCloudWatchMetrics() {
        return cloudWatchMetrics != null && !(cloudWatchMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics
     * that displayed anomalous behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCloudWatchMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed
     *         metrics that displayed anomalous behavior.
     */
    public final List<RecommendationRelatedCloudWatchMetricsSourceDetail> cloudWatchMetrics() {
        return cloudWatchMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchMetrics() ? cloudWatchMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationRelatedAnomalySourceDetail)) {
            return false;
        }
        RecommendationRelatedAnomalySourceDetail other = (RecommendationRelatedAnomalySourceDetail) obj;
        return hasCloudWatchMetrics() == other.hasCloudWatchMetrics()
                && Objects.equals(cloudWatchMetrics(), other.cloudWatchMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationRelatedAnomalySourceDetail")
                .add("CloudWatchMetrics", hasCloudWatchMetrics() ? cloudWatchMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchMetrics":
            return Optional.ofNullable(clazz.cast(cloudWatchMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationRelatedAnomalySourceDetail, T> g) {
        return obj -> g.apply((RecommendationRelatedAnomalySourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationRelatedAnomalySourceDetail> {
        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics
         * that displayed anomalous behavior.
         * </p>
         * 
         * @param cloudWatchMetrics
         *        An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed
         *        metrics that displayed anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetrics(Collection<RecommendationRelatedCloudWatchMetricsSourceDetail> cloudWatchMetrics);

        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics
         * that displayed anomalous behavior.
         * </p>
         * 
         * @param cloudWatchMetrics
         *        An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed
         *        metrics that displayed anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetrics(RecommendationRelatedCloudWatchMetricsSourceDetail... cloudWatchMetrics);

        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics
         * that displayed anomalous behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <RecommendationRelatedCloudWatchMetricsSourceDetail>.Builder} avoiding the need to create one manually via
         * {@link List<RecommendationRelatedCloudWatchMetricsSourceDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <RecommendationRelatedCloudWatchMetricsSourceDetail>.Builder#build()} is called immediately and its result is
         * passed to {@link #cloudWatchMetrics(List<RecommendationRelatedCloudWatchMetricsSourceDetail>)}.
         * 
         * @param cloudWatchMetrics
         *        a consumer that will call methods on {@link List
         *        <RecommendationRelatedCloudWatchMetricsSourceDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchMetrics(List<RecommendationRelatedCloudWatchMetricsSourceDetail>)
         */
        Builder cloudWatchMetrics(Consumer<RecommendationRelatedCloudWatchMetricsSourceDetail.Builder>... cloudWatchMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<RecommendationRelatedCloudWatchMetricsSourceDetail> cloudWatchMetrics = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationRelatedAnomalySourceDetail model) {
            cloudWatchMetrics(model.cloudWatchMetrics);
        }

        public final Collection<RecommendationRelatedCloudWatchMetricsSourceDetail.Builder> getCloudWatchMetrics() {
            if (cloudWatchMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return cloudWatchMetrics != null ? cloudWatchMetrics.stream()
                    .map(RecommendationRelatedCloudWatchMetricsSourceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchMetrics(Collection<RecommendationRelatedCloudWatchMetricsSourceDetail> cloudWatchMetrics) {
            this.cloudWatchMetrics = RecommendationRelatedCloudWatchMetricsSourceDetailsCopier.copy(cloudWatchMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(RecommendationRelatedCloudWatchMetricsSourceDetail... cloudWatchMetrics) {
            cloudWatchMetrics(Arrays.asList(cloudWatchMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(
                Consumer<RecommendationRelatedCloudWatchMetricsSourceDetail.Builder>... cloudWatchMetrics) {
            cloudWatchMetrics(Stream.of(cloudWatchMetrics)
                    .map(c -> RecommendationRelatedCloudWatchMetricsSourceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchMetrics(
                Collection<RecommendationRelatedCloudWatchMetricsSourceDetail.BuilderImpl> cloudWatchMetrics) {
            this.cloudWatchMetrics = RecommendationRelatedCloudWatchMetricsSourceDetailsCopier.copyFromBuilder(cloudWatchMetrics);
        }

        @Override
        public RecommendationRelatedAnomalySourceDetail build() {
            return new RecommendationRelatedAnomalySourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
