/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a reactive insight. This object is returned by <code>ListInsights</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactiveInsight implements SdkPojo, Serializable, ToCopyableBuilder<ReactiveInsight.Builder, ReactiveInsight> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ReactiveInsight::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ReactiveInsight::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ReactiveInsight::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReactiveInsight::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField
            .<InsightTimeRange> builder(MarshallingType.SDK_POJO).memberName("InsightTimeRange")
            .getter(getter(ReactiveInsight::insightTimeRange)).setter(setter(Builder::insightTimeRange))
            .constructor(InsightTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ReactiveInsight::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<String> SSM_OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SsmOpsItemId").getter(getter(ReactiveInsight::ssmOpsItemId)).setter(setter(Builder::ssmOpsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmOpsItemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            SEVERITY_FIELD, STATUS_FIELD, INSIGHT_TIME_RANGE_FIELD, RESOURCE_COLLECTION_FIELD, SSM_OPS_ITEM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String severity;

    private final String status;

    private final InsightTimeRange insightTimeRange;

    private final ResourceCollection resourceCollection;

    private final String ssmOpsItemId;

    private ReactiveInsight(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.severity = builder.severity;
        this.status = builder.status;
        this.insightTimeRange = builder.insightTimeRange;
        this.resourceCollection = builder.resourceCollection;
        this.ssmOpsItemId = builder.ssmOpsItemId;
    }

    /**
     * <p>
     * The ID of a reactive insight.
     * </p>
     * 
     * @return The ID of a reactive insight.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of a reactive insight.
     * </p>
     * 
     * @return The name of a reactive insight.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The severity of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of a reactive insight.
     * @see InsightSeverity
     */
    public final InsightSeverity severity() {
        return InsightSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of a reactive insight.
     * @see InsightSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a reactive insight.
     * @see InsightStatus
     */
    public final InsightStatus status() {
        return InsightStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a reactive insight.
     * @see InsightStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the InsightTimeRange property for this object.
     * 
     * @return The value of the InsightTimeRange property for this object.
     */
    public final InsightTimeRange insightTimeRange() {
        return insightTimeRange;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of OpstItems
     * insights before they are created for each insight.
     * </p>
     * 
     * @return The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of
     *         OpstItems insights before they are created for each insight.
     */
    public final String ssmOpsItemId() {
        return ssmOpsItemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(ssmOpsItemId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveInsight)) {
            return false;
        }
        ReactiveInsight other = (ReactiveInsight) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(insightTimeRange(), other.insightTimeRange())
                && Objects.equals(resourceCollection(), other.resourceCollection())
                && Objects.equals(ssmOpsItemId(), other.ssmOpsItemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactiveInsight").add("Id", id()).add("Name", name()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("InsightTimeRange", insightTimeRange())
                .add("ResourceCollection", resourceCollection()).add("SsmOpsItemId", ssmOpsItemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InsightTimeRange":
            return Optional.ofNullable(clazz.cast(insightTimeRange()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "SsmOpsItemId":
            return Optional.ofNullable(clazz.cast(ssmOpsItemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactiveInsight, T> g) {
        return obj -> g.apply((ReactiveInsight) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactiveInsight> {
        /**
         * <p>
         * The ID of a reactive insight.
         * </p>
         * 
         * @param id
         *        The ID of a reactive insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of a reactive insight.
         * </p>
         * 
         * @param name
         *        The name of a reactive insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The severity of a reactive insight.
         * </p>
         * 
         * @param severity
         *        The severity of a reactive insight.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of a reactive insight.
         * </p>
         * 
         * @param severity
         *        The severity of a reactive insight.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(InsightSeverity severity);

        /**
         * <p>
         * The status of a reactive insight.
         * </p>
         * 
         * @param status
         *        The status of a reactive insight.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a reactive insight.
         * </p>
         * 
         * @param status
         *        The status of a reactive insight.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(InsightStatus status);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * @param insightTimeRange
         *        The new value for the InsightTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightTimeRange(InsightTimeRange insightTimeRange);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link InsightTimeRange.Builder} avoiding the need to
         * create one manually via {@link InsightTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link InsightTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #insightTimeRange(InsightTimeRange)}.
         * 
         * @param insightTimeRange
         *        a consumer that will call methods on {@link InsightTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightTimeRange(InsightTimeRange)
         */
        default Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return insightTimeRange(InsightTimeRange.builder().applyMutation(insightTimeRange).build());
        }

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceCollection.Builder} avoiding the need to
         * create one manually via {@link ResourceCollection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of OpstItems
         * insights before they are created for each insight.
         * </p>
         * 
         * @param ssmOpsItemId
         *        The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of
         *        OpstItems insights before they are created for each insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmOpsItemId(String ssmOpsItemId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String severity;

        private String status;

        private InsightTimeRange insightTimeRange;

        private ResourceCollection resourceCollection;

        private String ssmOpsItemId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveInsight model) {
            id(model.id);
            name(model.name);
            severity(model.severity);
            status(model.status);
            insightTimeRange(model.insightTimeRange);
            resourceCollection(model.resourceCollection);
            ssmOpsItemId(model.ssmOpsItemId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return insightTimeRange != null ? insightTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final String getSsmOpsItemId() {
            return ssmOpsItemId;
        }

        @Override
        public final Builder ssmOpsItemId(String ssmOpsItemId) {
            this.ssmOpsItemId = ssmOpsItemId;
            return this;
        }

        public final void setSsmOpsItemId(String ssmOpsItemId) {
            this.ssmOpsItemId = ssmOpsItemId;
        }

        @Override
        public ReactiveInsight build() {
            return new ReactiveInsight(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
