/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomaliesForInsightResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<ListAnomaliesForInsightResponse.Builder, ListAnomaliesForInsightResponse> {
    private static final SdkField<List<ProactiveAnomalySummary>> PROACTIVE_ANOMALIES_FIELD = SdkField
            .<List<ProactiveAnomalySummary>> builder(MarshallingType.LIST)
            .memberName("ProactiveAnomalies")
            .getter(getter(ListAnomaliesForInsightResponse::proactiveAnomalies))
            .setter(setter(Builder::proactiveAnomalies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveAnomalies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProactiveAnomalySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProactiveAnomalySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReactiveAnomalySummary>> REACTIVE_ANOMALIES_FIELD = SdkField
            .<List<ReactiveAnomalySummary>> builder(MarshallingType.LIST)
            .memberName("ReactiveAnomalies")
            .getter(getter(ListAnomaliesForInsightResponse::reactiveAnomalies))
            .setter(setter(Builder::reactiveAnomalies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveAnomalies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReactiveAnomalySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReactiveAnomalySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomaliesForInsightResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_ANOMALIES_FIELD,
            REACTIVE_ANOMALIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ProactiveAnomalySummary> proactiveAnomalies;

    private final List<ReactiveAnomalySummary> reactiveAnomalies;

    private final String nextToken;

    private ListAnomaliesForInsightResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveAnomalies = builder.proactiveAnomalies;
        this.reactiveAnomalies = builder.reactiveAnomalies;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProactiveAnomalies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProactiveAnomalies() {
        return proactiveAnomalies != null && !(proactiveAnomalies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProactiveAnomalies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
     */
    public final List<ProactiveAnomalySummary> proactiveAnomalies() {
        return proactiveAnomalies;
    }

    /**
     * Returns true if the ReactiveAnomalies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReactiveAnomalies() {
        return reactiveAnomalies != null && !(reactiveAnomalies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactiveAnomalies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
     */
    public final List<ReactiveAnomalySummary> reactiveAnomalies() {
        return reactiveAnomalies;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProactiveAnomalies() ? proactiveAnomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReactiveAnomalies() ? reactiveAnomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesForInsightResponse)) {
            return false;
        }
        ListAnomaliesForInsightResponse other = (ListAnomaliesForInsightResponse) obj;
        return hasProactiveAnomalies() == other.hasProactiveAnomalies()
                && Objects.equals(proactiveAnomalies(), other.proactiveAnomalies())
                && hasReactiveAnomalies() == other.hasReactiveAnomalies()
                && Objects.equals(reactiveAnomalies(), other.reactiveAnomalies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomaliesForInsightResponse")
                .add("ProactiveAnomalies", hasProactiveAnomalies() ? proactiveAnomalies() : null)
                .add("ReactiveAnomalies", hasReactiveAnomalies() ? reactiveAnomalies() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProactiveAnomalies":
            return Optional.ofNullable(clazz.cast(proactiveAnomalies()));
        case "ReactiveAnomalies":
            return Optional.ofNullable(clazz.cast(reactiveAnomalies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomaliesForInsightResponse, T> g) {
        return obj -> g.apply((ListAnomaliesForInsightResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomaliesForInsightResponse> {
        /**
         * <p>
         * An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * 
         * @param proactiveAnomalies
         *        An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveAnomalies(Collection<ProactiveAnomalySummary> proactiveAnomalies);

        /**
         * <p>
         * An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * 
         * @param proactiveAnomalies
         *        An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveAnomalies(ProactiveAnomalySummary... proactiveAnomalies);

        /**
         * <p>
         * An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProactiveAnomalySummary>.Builder} avoiding
         * the need to create one manually via {@link List<ProactiveAnomalySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProactiveAnomalySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #proactiveAnomalies(List<ProactiveAnomalySummary>)}.
         * 
         * @param proactiveAnomalies
         *        a consumer that will call methods on {@link List<ProactiveAnomalySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveAnomalies(List<ProactiveAnomalySummary>)
         */
        Builder proactiveAnomalies(Consumer<ProactiveAnomalySummary.Builder>... proactiveAnomalies);

        /**
         * <p>
         * An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * 
         * @param reactiveAnomalies
         *        An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveAnomalies(Collection<ReactiveAnomalySummary> reactiveAnomalies);

        /**
         * <p>
         * An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * 
         * @param reactiveAnomalies
         *        An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveAnomalies(ReactiveAnomalySummary... reactiveAnomalies);

        /**
         * <p>
         * An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReactiveAnomalySummary>.Builder} avoiding
         * the need to create one manually via {@link List<ReactiveAnomalySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReactiveAnomalySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #reactiveAnomalies(List<ReactiveAnomalySummary>)}.
         * 
         * @param reactiveAnomalies
         *        a consumer that will call methods on {@link List<ReactiveAnomalySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reactiveAnomalies(List<ReactiveAnomalySummary>)
         */
        Builder reactiveAnomalies(Consumer<ReactiveAnomalySummary.Builder>... reactiveAnomalies);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private List<ProactiveAnomalySummary> proactiveAnomalies = DefaultSdkAutoConstructList.getInstance();

        private List<ReactiveAnomalySummary> reactiveAnomalies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomaliesForInsightResponse model) {
            super(model);
            proactiveAnomalies(model.proactiveAnomalies);
            reactiveAnomalies(model.reactiveAnomalies);
            nextToken(model.nextToken);
        }

        public final Collection<ProactiveAnomalySummary.Builder> getProactiveAnomalies() {
            if (proactiveAnomalies instanceof SdkAutoConstructList) {
                return null;
            }
            return proactiveAnomalies != null ? proactiveAnomalies.stream().map(ProactiveAnomalySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder proactiveAnomalies(Collection<ProactiveAnomalySummary> proactiveAnomalies) {
            this.proactiveAnomalies = ProactiveAnomaliesCopier.copy(proactiveAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveAnomalies(ProactiveAnomalySummary... proactiveAnomalies) {
            proactiveAnomalies(Arrays.asList(proactiveAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveAnomalies(Consumer<ProactiveAnomalySummary.Builder>... proactiveAnomalies) {
            proactiveAnomalies(Stream.of(proactiveAnomalies).map(c -> ProactiveAnomalySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProactiveAnomalies(Collection<ProactiveAnomalySummary.BuilderImpl> proactiveAnomalies) {
            this.proactiveAnomalies = ProactiveAnomaliesCopier.copyFromBuilder(proactiveAnomalies);
        }

        public final Collection<ReactiveAnomalySummary.Builder> getReactiveAnomalies() {
            if (reactiveAnomalies instanceof SdkAutoConstructList) {
                return null;
            }
            return reactiveAnomalies != null ? reactiveAnomalies.stream().map(ReactiveAnomalySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reactiveAnomalies(Collection<ReactiveAnomalySummary> reactiveAnomalies) {
            this.reactiveAnomalies = ReactiveAnomaliesCopier.copy(reactiveAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveAnomalies(ReactiveAnomalySummary... reactiveAnomalies) {
            reactiveAnomalies(Arrays.asList(reactiveAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveAnomalies(Consumer<ReactiveAnomalySummary.Builder>... reactiveAnomalies) {
            reactiveAnomalies(Stream.of(reactiveAnomalies).map(c -> ReactiveAnomalySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReactiveAnomalies(Collection<ReactiveAnomalySummary.BuilderImpl> reactiveAnomalies) {
            this.reactiveAnomalies = ReactiveAnomaliesCopier.copyFromBuilder(reactiveAnomalies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnomaliesForInsightResponse build() {
            return new ListAnomaliesForInsightResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
