/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about insight feedback received from a customer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightFeedback implements SdkPojo, Serializable, ToCopyableBuilder<InsightFeedback.Builder, InsightFeedback> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(InsightFeedback::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Feedback").getter(getter(InsightFeedback::feedbackAsString)).setter(setter(Builder::feedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FEEDBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String feedback;

    private InsightFeedback(BuilderImpl builder) {
        this.id = builder.id;
        this.feedback = builder.feedback;
    }

    /**
     * <p>
     * The insight feedback ID.
     * </p>
     * 
     * @return The insight feedback ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The feedback provided by the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link InsightFeedbackOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return The feedback provided by the customer.
     * @see InsightFeedbackOption
     */
    public final InsightFeedbackOption feedback() {
        return InsightFeedbackOption.fromValue(feedback);
    }

    /**
     * <p>
     * The feedback provided by the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link InsightFeedbackOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return The feedback provided by the customer.
     * @see InsightFeedbackOption
     */
    public final String feedbackAsString() {
        return feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightFeedback)) {
            return false;
        }
        InsightFeedback other = (InsightFeedback) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(feedbackAsString(), other.feedbackAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightFeedback").add("Id", id()).add("Feedback", feedbackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Feedback":
            return Optional.ofNullable(clazz.cast(feedbackAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightFeedback, T> g) {
        return obj -> g.apply((InsightFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightFeedback> {
        /**
         * <p>
         * The insight feedback ID.
         * </p>
         * 
         * @param id
         *        The insight feedback ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The feedback provided by the customer.
         * </p>
         * 
         * @param feedback
         *        The feedback provided by the customer.
         * @see InsightFeedbackOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightFeedbackOption
         */
        Builder feedback(String feedback);

        /**
         * <p>
         * The feedback provided by the customer.
         * </p>
         * 
         * @param feedback
         *        The feedback provided by the customer.
         * @see InsightFeedbackOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightFeedbackOption
         */
        Builder feedback(InsightFeedbackOption feedback);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightFeedback model) {
            id(model.id);
            feedback(model.feedback);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getFeedback() {
            return feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(InsightFeedbackOption feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public InsightFeedback build() {
            return new InsightFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
