/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse;
import software.amazon.awssdk.services.devopsguru.model.NotificationChannel;

public class ListNotificationChannelsPublisher
implements SdkPublisher<ListNotificationChannelsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListNotificationChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationChannelsPublisher(DevOpsGuruAsyncClient client, ListNotificationChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationChannelsPublisher(DevOpsGuruAsyncClient client, ListNotificationChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationChannel> channels() {
        Function<ListNotificationChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channels() != null) {
                return response.channels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationChannelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationChannelsResponseFetcher
    implements AsyncPageFetcher<ListNotificationChannelsResponse> {
        private ListNotificationChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationChannelsResponse> nextPage(ListNotificationChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationChannelsPublisher.this.client.listNotificationChannels(ListNotificationChannelsPublisher.this.firstRequest);
            }
            return ListNotificationChannelsPublisher.this.client.listNotificationChannels((ListNotificationChannelsRequest)((Object)ListNotificationChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

