/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionAction;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceCollectionRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, UpdateResourceCollectionRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(UpdateResourceCollectionRequest.getter(UpdateResourceCollectionRequest::actionAsString)).setter(UpdateResourceCollectionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<UpdateResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(UpdateResourceCollectionRequest.getter(UpdateResourceCollectionRequest::resourceCollection)).setter(UpdateResourceCollectionRequest.setter(Builder::resourceCollection)).constructor(UpdateResourceCollectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, RESOURCE_COLLECTION_FIELD));
    private final String action;
    private final UpdateResourceCollectionFilter resourceCollection;

    private UpdateResourceCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.resourceCollection = builder.resourceCollection;
    }

    public final UpdateResourceCollectionAction action() {
        return UpdateResourceCollectionAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final UpdateResourceCollectionFilter resourceCollection() {
        return this.resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceCollectionRequest)) {
            return false;
        }
        UpdateResourceCollectionRequest other = (UpdateResourceCollectionRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.resourceCollection(), other.resourceCollection());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceCollectionRequest").add("Action", (Object)this.actionAsString()).add("ResourceCollection", (Object)this.resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceCollectionRequest, T> g) {
        return obj -> g.apply((UpdateResourceCollectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private String action;
        private UpdateResourceCollectionFilter resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceCollectionRequest model) {
            super(model);
            this.action(model.action);
            this.resourceCollection(model.resourceCollection);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateResourceCollectionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final UpdateResourceCollectionFilter.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(UpdateResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(UpdateResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceCollectionRequest build() {
            return new UpdateResourceCollectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceCollectionRequest> {
        public Builder action(String var1);

        public Builder action(UpdateResourceCollectionAction var1);

        public Builder resourceCollection(UpdateResourceCollectionFilter var1);

        default public Builder resourceCollection(Consumer<UpdateResourceCollectionFilter.Builder> resourceCollection) {
            return this.resourceCollection((UpdateResourceCollectionFilter)((UpdateResourceCollectionFilter.Builder)UpdateResourceCollectionFilter.builder().applyMutation(resourceCollection)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

