/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventClass {
    INFRASTRUCTURE("INFRASTRUCTURE"),
    DEPLOYMENT("DEPLOYMENT"),
    SECURITY_CHANGE("SECURITY_CHANGE"),
    CONFIG_CHANGE("CONFIG_CHANGE"),
    SCHEMA_CHANGE("SCHEMA_CHANGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventClass> knownValues() {
        return Stream.of(EventClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

