/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.InsightStatus;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.services.devopsguru.model.___listOfInsightSeverityCopier;
import software.amazon.awssdk.services.devopsguru.model.___listOfInsightStatusCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchInsightsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchInsightsFilters> {
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(SearchInsightsFilters.getter(SearchInsightsFilters::resourceCollection)).setter(SearchInsightsFilters.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Severities").getter(SearchInsightsFilters.getter(SearchInsightsFilters::severitiesAsStrings)).setter(SearchInsightsFilters.setter(Builder::severitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(SearchInsightsFilters.getter(SearchInsightsFilters::statusesAsStrings)).setter(SearchInsightsFilters.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_FIELD, SEVERITIES_FIELD, STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceCollection resourceCollection;
    private final List<String> severities;
    private final List<String> statuses;

    private SearchInsightsFilters(BuilderImpl builder) {
        this.resourceCollection = builder.resourceCollection;
        this.severities = builder.severities;
        this.statuses = builder.statuses;
    }

    public ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public List<InsightSeverity> severities() {
        return ___listOfInsightSeverityCopier.copyStringToEnum(this.severities);
    }

    public boolean hasSeverities() {
        return this.severities != null && !(this.severities instanceof SdkAutoConstructList);
    }

    public List<String> severitiesAsStrings() {
        return this.severities;
    }

    public List<InsightStatus> statuses() {
        return ___listOfInsightStatusCopier.copyStringToEnum(this.statuses);
    }

    public boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public List<String> statusesAsStrings() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeverities() ? this.severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInsightsFilters)) {
            return false;
        }
        SearchInsightsFilters other = (SearchInsightsFilters)obj;
        return Objects.equals(this.resourceCollection(), other.resourceCollection()) && this.hasSeverities() == other.hasSeverities() && Objects.equals(this.severitiesAsStrings(), other.severitiesAsStrings()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"SearchInsightsFilters").add("ResourceCollection", (Object)this.resourceCollection()).add("Severities", this.hasSeverities() ? this.severitiesAsStrings() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Severities": {
                return Optional.ofNullable(clazz.cast(this.severitiesAsStrings()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchInsightsFilters, T> g) {
        return obj -> g.apply((SearchInsightsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceCollection resourceCollection;
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInsightsFilters model) {
            this.resourceCollection(model.resourceCollection);
            this.severitiesWithStrings(model.severities);
            this.statusesWithStrings(model.statuses);
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final Collection<String> getSeverities() {
            if (this.severities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.severities;
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = ___listOfInsightSeverityCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String ... severities) {
            this.severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = ___listOfInsightSeverityCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity ... severities) {
            this.severities(Arrays.asList(severities));
            return this;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = ___listOfInsightSeverityCopier.copy(severities);
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ___listOfInsightStatusCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatus> statuses) {
            this.statuses = ___listOfInsightStatusCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ___listOfInsightStatusCopier.copy(statuses);
        }

        public SearchInsightsFilters build() {
            return new SearchInsightsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchInsightsFilters> {
        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder severitiesWithStrings(Collection<String> var1);

        public Builder severitiesWithStrings(String ... var1);

        public Builder severities(Collection<InsightSeverity> var1);

        public Builder severities(InsightSeverity ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<InsightStatus> var1);

        public Builder statuses(InsightStatus ... var1);
    }
}

