/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.___listOf__stringMin1Max128PatternAZAZAZAZ09Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationCollectionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationCollectionFilter> {
    private static final SdkField<List<String>> STACK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackNames").getter(CloudFormationCollectionFilter.getter(CloudFormationCollectionFilter::stackNames)).setter(CloudFormationCollectionFilter.setter(Builder::stackNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> stackNames;

    private CloudFormationCollectionFilter(BuilderImpl builder) {
        this.stackNames = builder.stackNames;
    }

    public boolean hasStackNames() {
        return this.stackNames != null && !(this.stackNames instanceof SdkAutoConstructList);
    }

    public List<String> stackNames() {
        return this.stackNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackNames() ? this.stackNames() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationCollectionFilter)) {
            return false;
        }
        CloudFormationCollectionFilter other = (CloudFormationCollectionFilter)obj;
        return this.hasStackNames() == other.hasStackNames() && Objects.equals(this.stackNames(), other.stackNames());
    }

    public String toString() {
        return ToString.builder((String)"CloudFormationCollectionFilter").add("StackNames", this.hasStackNames() ? this.stackNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackNames": {
                return Optional.ofNullable(clazz.cast(this.stackNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationCollectionFilter, T> g) {
        return obj -> g.apply((CloudFormationCollectionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stackNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationCollectionFilter model) {
            this.stackNames(model.stackNames);
        }

        public final Collection<String> getStackNames() {
            if (this.stackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackNames;
        }

        @Override
        public final Builder stackNames(Collection<String> stackNames) {
            this.stackNames = ___listOf__stringMin1Max128PatternAZAZAZAZ09Copier.copy(stackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackNames(String ... stackNames) {
            this.stackNames(Arrays.asList(stackNames));
            return this;
        }

        public final void setStackNames(Collection<String> stackNames) {
            this.stackNames = ___listOf__stringMin1Max128PatternAZAZAZAZ09Copier.copy(stackNames);
        }

        public CloudFormationCollectionFilter build() {
            return new CloudFormationCollectionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationCollectionFilter> {
        public Builder stackNames(Collection<String> var1);

        public Builder stackNames(String ... var1);
    }
}

