/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.SessionActionSummary;

public class ListSessionActionsIterable
implements SdkIterable<ListSessionActionsResponse> {
    private final DeadlineClient client;
    private final ListSessionActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionActionsIterable(DeadlineClient client, ListSessionActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionActionsResponseFetcher();
    }

    public Iterator<ListSessionActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SessionActionSummary> sessionActions() {
        Function<ListSessionActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionActions() != null) {
                return response.sessionActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSessionActionsResponseFetcher
    implements SyncPageFetcher<ListSessionActionsResponse> {
        private ListSessionActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionActionsResponse nextPage(ListSessionActionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionActionsIterable.this.client.listSessionActions(ListSessionActionsIterable.this.firstRequest);
            }
            return ListSessionActionsIterable.this.client.listSessionActions((ListSessionActionsRequest)((Object)ListSessionActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

