/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary;

public class ListQueueEnvironmentsPublisher
implements SdkPublisher<ListQueueEnvironmentsResponse> {
    private final DeadlineAsyncClient client;
    private final ListQueueEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueueEnvironmentsPublisher(DeadlineAsyncClient client, ListQueueEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueueEnvironmentsPublisher(DeadlineAsyncClient client, ListQueueEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueueEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueueEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueueEnvironmentSummary> environments() {
        Function<ListQueueEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueueEnvironmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueueEnvironmentsResponseFetcher
    implements AsyncPageFetcher<ListQueueEnvironmentsResponse> {
        private ListQueueEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueueEnvironmentsResponse> nextPage(ListQueueEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueEnvironmentsPublisher.this.client.listQueueEnvironments(ListQueueEnvironmentsPublisher.this.firstRequest);
            }
            return ListQueueEnvironmentsPublisher.this.client.listQueueEnvironments((ListQueueEnvironmentsRequest)((Object)ListQueueEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

