/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ConfigurationStatus;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataExportConfigurationResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetDataExportConfigurationResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::createdAt)).setter(GetDataExportConfigurationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::encryptionConfiguration)).setter(GetDataExportConfigurationResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<Boolean> IS_EXPORT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isExportEnabled").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::isExportEnabled)).setter(GetDataExportConfigurationResponse.setter(Builder::isExportEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExportEnabled").build()}).build();
    private static final SdkField<String> S3_TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3TableBucketArn").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::s3TableBucketArn)).setter(GetDataExportConfigurationResponse.setter(Builder::s3TableBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3TableBucketArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::statusAsString)).setter(GetDataExportConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetDataExportConfigurationResponse.getter(GetDataExportConfigurationResponse::updatedAt)).setter(GetDataExportConfigurationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ENCRYPTION_CONFIGURATION_FIELD, IS_EXPORT_ENABLED_FIELD, S3_TABLE_BUCKET_ARN_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataExportConfigurationResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Boolean isExportEnabled;
    private final String s3TableBucketArn;
    private final String status;
    private final Instant updatedAt;

    private GetDataExportConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.isExportEnabled = builder.isExportEnabled;
        this.s3TableBucketArn = builder.s3TableBucketArn;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Boolean isExportEnabled() {
        return this.isExportEnabled;
    }

    public final String s3TableBucketArn() {
        return this.s3TableBucketArn;
    }

    public final ConfigurationStatus status() {
        return ConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isExportEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3TableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataExportConfigurationResponse)) {
            return false;
        }
        GetDataExportConfigurationResponse other = (GetDataExportConfigurationResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.isExportEnabled(), other.isExportEnabled()) && Objects.equals(this.s3TableBucketArn(), other.s3TableBucketArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataExportConfigurationResponse").add("CreatedAt", (Object)this.createdAt()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("IsExportEnabled", (Object)this.isExportEnabled()).add("S3TableBucketArn", (Object)this.s3TableBucketArn()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "isExportEnabled": {
                return Optional.ofNullable(clazz.cast(this.isExportEnabled()));
            }
            case "s3TableBucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3TableBucketArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("isExportEnabled", IS_EXPORT_ENABLED_FIELD);
        map.put("s3TableBucketArn", S3_TABLE_BUCKET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataExportConfigurationResponse, T> g) {
        return obj -> g.apply((GetDataExportConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private EncryptionConfiguration encryptionConfiguration;
        private Boolean isExportEnabled;
        private String s3TableBucketArn;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataExportConfigurationResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.isExportEnabled(model.isExportEnabled);
            this.s3TableBucketArn(model.s3TableBucketArn);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Boolean getIsExportEnabled() {
            return this.isExportEnabled;
        }

        public final void setIsExportEnabled(Boolean isExportEnabled) {
            this.isExportEnabled = isExportEnabled;
        }

        @Override
        public final Builder isExportEnabled(Boolean isExportEnabled) {
            this.isExportEnabled = isExportEnabled;
            return this;
        }

        public final String getS3TableBucketArn() {
            return this.s3TableBucketArn;
        }

        public final void setS3TableBucketArn(String s3TableBucketArn) {
            this.s3TableBucketArn = s3TableBucketArn;
        }

        @Override
        public final Builder s3TableBucketArn(String s3TableBucketArn) {
            this.s3TableBucketArn = s3TableBucketArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataExportConfigurationResponse build() {
            return new GetDataExportConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataExportConfigurationResponse> {
        public Builder createdAt(Instant var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder isExportEnabled(Boolean var1);

        public Builder s3TableBucketArn(String var1);

        public Builder status(String var1);

        public Builder status(ConfigurationStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

