/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRootDomainUnitOwnerRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateRootDomainUnitOwnerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateRootDomainUnitOwnerRequest.getter(UpdateRootDomainUnitOwnerRequest::clientToken)).setter(UpdateRootDomainUnitOwnerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CURRENT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentOwner").getter(UpdateRootDomainUnitOwnerRequest.getter(UpdateRootDomainUnitOwnerRequest::currentOwner)).setter(UpdateRootDomainUnitOwnerRequest.setter(Builder::currentOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentOwner").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateRootDomainUnitOwnerRequest.getter(UpdateRootDomainUnitOwnerRequest::domainIdentifier)).setter(UpdateRootDomainUnitOwnerRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> NEW_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newOwner").getter(UpdateRootDomainUnitOwnerRequest.getter(UpdateRootDomainUnitOwnerRequest::newOwner)).setter(UpdateRootDomainUnitOwnerRequest.setter(Builder::newOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CURRENT_OWNER_FIELD, DOMAIN_IDENTIFIER_FIELD, NEW_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRootDomainUnitOwnerRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String currentOwner;
    private final String domainIdentifier;
    private final String newOwner;

    private UpdateRootDomainUnitOwnerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currentOwner = builder.currentOwner;
        this.domainIdentifier = builder.domainIdentifier;
        this.newOwner = builder.newOwner;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String currentOwner() {
        return this.currentOwner;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String newOwner() {
        return this.newOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.newOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRootDomainUnitOwnerRequest)) {
            return false;
        }
        UpdateRootDomainUnitOwnerRequest other = (UpdateRootDomainUnitOwnerRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.currentOwner(), other.currentOwner()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.newOwner(), other.newOwner());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRootDomainUnitOwnerRequest").add("ClientToken", (Object)this.clientToken()).add("CurrentOwner", (Object)this.currentOwner()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("NewOwner", (Object)this.newOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "currentOwner": {
                return Optional.ofNullable(clazz.cast(this.currentOwner()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "newOwner": {
                return Optional.ofNullable(clazz.cast(this.newOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("currentOwner", CURRENT_OWNER_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("newOwner", NEW_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRootDomainUnitOwnerRequest, T> g) {
        return obj -> g.apply((UpdateRootDomainUnitOwnerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String currentOwner;
        private String domainIdentifier;
        private String newOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRootDomainUnitOwnerRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.currentOwner(model.currentOwner);
            this.domainIdentifier(model.domainIdentifier);
            this.newOwner(model.newOwner);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCurrentOwner() {
            return this.currentOwner;
        }

        public final void setCurrentOwner(String currentOwner) {
            this.currentOwner = currentOwner;
        }

        @Override
        public final Builder currentOwner(String currentOwner) {
            this.currentOwner = currentOwner;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getNewOwner() {
            return this.newOwner;
        }

        public final void setNewOwner(String newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public final Builder newOwner(String newOwner) {
            this.newOwner = newOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRootDomainUnitOwnerRequest build() {
            return new UpdateRootDomainUnitOwnerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRootDomainUnitOwnerRequest> {
        public Builder clientToken(String var1);

        public Builder currentOwner(String var1);

        public Builder domainIdentifier(String var1);

        public Builder newOwner(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

