/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftStorageProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftStorageProperties> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(RedshiftStorageProperties.getter(RedshiftStorageProperties::clusterName)).setter(RedshiftStorageProperties.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(RedshiftStorageProperties.getter(RedshiftStorageProperties::workgroupName)).setter(RedshiftStorageProperties.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftStorageProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String workgroupName;
    private final Type type;

    private RedshiftStorageProperties(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.workgroupName = builder.workgroupName;
        this.type = builder.type;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftStorageProperties)) {
            return false;
        }
        RedshiftStorageProperties other = (RedshiftStorageProperties)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftStorageProperties").add("ClusterName", (Object)this.clusterName()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public static RedshiftStorageProperties fromClusterName(String clusterName) {
        return (RedshiftStorageProperties)RedshiftStorageProperties.builder().clusterName(clusterName).build();
    }

    public static RedshiftStorageProperties fromWorkgroupName(String workgroupName) {
        return (RedshiftStorageProperties)RedshiftStorageProperties.builder().workgroupName(workgroupName).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftStorageProperties, T> g) {
        return obj -> g.apply((RedshiftStorageProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLUSTER_NAME,
        WORKGROUP_NAME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String workgroupName;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftStorageProperties model) {
            this.clusterName(model.clusterName);
            this.workgroupName(model.workgroupName);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            String oldValue = this.clusterName;
            this.clusterName = clusterName;
            this.handleUnionValueChange(Type.CLUSTER_NAME, oldValue, this.clusterName);
        }

        @Override
        public final Builder clusterName(String clusterName) {
            String oldValue = this.clusterName;
            this.clusterName = clusterName;
            this.handleUnionValueChange(Type.CLUSTER_NAME, oldValue, this.clusterName);
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            String oldValue = this.workgroupName;
            this.workgroupName = workgroupName;
            this.handleUnionValueChange(Type.WORKGROUP_NAME, oldValue, this.workgroupName);
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            String oldValue = this.workgroupName;
            this.workgroupName = workgroupName;
            this.handleUnionValueChange(Type.WORKGROUP_NAME, oldValue, this.workgroupName);
            return this;
        }

        public RedshiftStorageProperties build() {
            return new RedshiftStorageProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftStorageProperties> {
        public Builder clusterName(String var1);

        public Builder workgroupName(String var1);
    }
}

