/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeInput> {
    private static final SdkField<String> ATTRIBUTE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeIdentifier").getter(AttributeInput.getter(AttributeInput::attributeIdentifier)).setter(AttributeInput.setter(Builder::attributeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeIdentifier").build()}).build();
    private static final SdkField<List<FormInput>> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("forms").getter(AttributeInput.getter(AttributeInput::forms)).setter(AttributeInput.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_IDENTIFIER_FIELD, FORMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeIdentifier;
    private final List<FormInput> forms;

    private AttributeInput(BuilderImpl builder) {
        this.attributeIdentifier = builder.attributeIdentifier;
        this.forms = builder.forms;
    }

    public final String attributeIdentifier() {
        return this.attributeIdentifier;
    }

    public final boolean hasForms() {
        return this.forms != null && !(this.forms instanceof SdkAutoConstructList);
    }

    public final List<FormInput> forms() {
        return this.forms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForms() ? this.forms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeInput)) {
            return false;
        }
        AttributeInput other = (AttributeInput)obj;
        return Objects.equals(this.attributeIdentifier(), other.attributeIdentifier()) && this.hasForms() == other.hasForms() && Objects.equals(this.forms(), other.forms());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeInput").add("AttributeIdentifier", (Object)this.attributeIdentifier()).add("Forms", (Object)(this.forms() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.attributeIdentifier()));
            }
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributeIdentifier", ATTRIBUTE_IDENTIFIER_FIELD);
        map.put("forms", FORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeInput, T> g) {
        return obj -> g.apply((AttributeInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeIdentifier;
        private List<FormInput> forms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeInput model) {
            this.attributeIdentifier(model.attributeIdentifier);
            this.forms(model.forms);
        }

        public final String getAttributeIdentifier() {
            return this.attributeIdentifier;
        }

        public final void setAttributeIdentifier(String attributeIdentifier) {
            this.attributeIdentifier = attributeIdentifier;
        }

        @Override
        public final Builder attributeIdentifier(String attributeIdentifier) {
            this.attributeIdentifier = attributeIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getForms() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.forms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForms(Collection<FormInput.BuilderImpl> forms) {
            this.forms = FormInputListCopier.copyFromBuilder(forms);
        }

        @Override
        public final Builder forms(Collection<FormInput> forms) {
            this.forms = FormInputListCopier.copy(forms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(FormInput ... forms) {
            this.forms(Arrays.asList(forms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(Consumer<FormInput.Builder> ... forms) {
            this.forms(Stream.of(forms).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AttributeInput build() {
            return new AttributeInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeInput> {
        public Builder attributeIdentifier(String var1);

        public Builder forms(Collection<FormInput> var1);

        public Builder forms(FormInput ... var1);

        public Builder forms(Consumer<FormInput.Builder> ... var1);
    }
}

